<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Block_23_View
 * @package JBP\Elements\Elements\Views
 */
class Block_23_View extends Block_View_Abstract {

	/**
	 * Build column type 1 method
	 *
	 * @param $results
	 *
	 * @return string
	 */
	public function build_column( $results ) {
		$first_block = '';
		$size        = count( $results );

		for ( $i = 0; $i < $size; $i ++ ) {
			$first_block .= $this->render_block_type_1( $results[ $i ], 'jeg-360x480' );
		}

		return $first_block;
	}

	/**
	 * Render block type 1 method
	 *
	 * @param $post
	 * @param $image_size
	 *
	 * @return string
	 */
	public function render_block_type_1( $post, $image_size ) {
		$thumbnail        = $this->get_thumbnail( $post->ID, $image_size );
		$primary_category = $this->get_primary_category( $post->ID );
		$author_url       = get_author_posts_url( $post->post_author );
		$author_name      = get_the_author_meta( 'display_name', $post->post_author );

		$output =
			'<article ' . jeg_post_class( 'jeg_post', $post->ID ) . '>
				<div class="jeg_thumb">
                    ' . jblog_edit_post( $post->ID ) . '
                    <a href="' . get_the_permalink( $post ) . '">' . $thumbnail . '</a>
                	<div class="jeg_post_category">
                        <span>' . $primary_category . '</span>
                    </div>
                </div>
                <div class="jeg_postblock_content">
                    <h3 class="jeg_post_title">
                        <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                    </h3>
                    <div class="jeg_post_meta">
                    	<div class="jeg_meta_author">
		                	<span class="by">' . esc_html__( 'by', 'jblog-elements' ) . '</span>
		                	<a href="' . $author_url . '">' . $author_name . '</a>
		            	</div>
		            </div>
                </div>
            </article>';

		return $output;
	}
}
