<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Block_Popular_View
 * @package JBP\Elements\Elements\Views
 */
class Block_Popular_View extends View_Abstract {

	/**
	 * Post index
	 */
	protected $post_index;

	/**
	 * Show hide category
	 *
	 * @var bool
	 */
	protected $show_category = false;

	/**
	 * Render Module
	 *
	 * @param array $attr Array of attribute.
	 * @param string $column_class Class string.
	 *
	 * @return string
	 */
	public function render_element( $attr, $column_class ) {
		$attr['post_type']              = 'post';
		$attr['post_offset']            = 0;
		$attr['sort_by']                = 'latest';

		if ( isset( $attr['results'] ) ) {
			$results = $attr['results'];
		} else {
			$results = $this->build_query( $attr );
		}

		$title = ! empty( $attr['title'] ) ? '<h3 class="jblog_block_title"><span>' . $attr['title'] . '</span></h3>' : "";

		if ( ! empty( $results['result'] ) ) {
			$this->post_index    = $attr['post_index'];
			$this->show_category = $attr['category'];
			$content             = $this->render_column( $results['result'] );
		} else {
			$content = $this->empty_content();
		}

		return
			'<div ' . $this->element_id( $attr ) . ' class="jeg_postblock ' . $this->id . ' ' . $this->unique_id . ' ' . $attr['el_class'] . ' ' . $this->get_vc_class_name() . ' ' . $this->color_scheme() . '">
				' . $title . '
				' . $content . '
			</div>';
	}

	/**
	 * Render column method
	 *
	 * @param array $result
	 *
	 * @return mixed|string
	 */
	public function render_column( $result ) {
		return
			'<div class="jeg_posts jeg_load_more_flag">
                ' . $this->build_column_1( $result ) . '
            </div>';
	}

	/**
	 * Build column type 1 method
	 *
	 * @param $results
	 *
	 * @return string
	 */
	public function build_column_1( $results ) {
		$first_block = '';
		$size        = count( $results );

		for ( $i = 0; $i < $size; $i ++ ) {

			$image_size = 'jeg-120x96';

			if ( '2' === $this->post_index ) {
				$image_size = 'jeg-90x90';
			}

			$first_block .= $this->render_block_type_1( $results[ $i ], $image_size, $i );
		}

		return $first_block;
	}

	/**
	 * Render block type 1 method
	 *
	 * @param $post
	 * @param $image_size
	 *
	 * @return string
	 */
	public function render_block_type_1( $post, $image_size, $index ) {
		$category  = $post_index = '';
		$thumbnail = $this->get_thumbnail( $post->ID, $image_size );

		if ( $this->show_category ) {
			$primary_category = $this->get_primary_category( $post->ID );
			$category         = '<div class="jeg_post_category"><span>' . $primary_category . '</span></div>';
		}

		if ( 'none' !== $this->post_index ) {
			$post_index = '<span class="post-index">' . ( $index + 1 ) . '</span>';
		}

		$output =
			'<article ' . jeg_post_class( 'jeg_post style-' . $this->post_index, $post->ID ) . '>
                <div class="jeg_thumb">
                    ' . jblog_edit_post( $post->ID ) . '
                    ' . $post_index . '
                    <a href="' . get_the_permalink( $post ) . '">' . $thumbnail . '</a>
                </div>
                <div class="jeg_postblock_content">
                	' . $category . '
                    <h3 class="jeg_post_title">
                        <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                    </h3>
                    <div class="jeg_post_meta">
                    	<div class="jeg_meta_date">' . $this->format_date( $post ) . '</div>
                    </div>
                </div>
            </article>';

		return $output;
	}
}
