<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Block_View_Abstract
 * @package JBP\Elements\Elements\Views
 */
abstract class Block_View_Abstract extends View_Abstract {

	/**
	 * Render Module
	 *
	 * @param array $attr Array of attribute.
	 * @param string $column_class Class string.
	 *
	 * @return string
	 */
	public function render_element( $attr, $column_class ) {
		$name    = str_replace( 'jblog_block_', '', $this->id );
		$content = $this->render_block_element( $attr );
		$script  = $this->render_script();

		$output =
			'<div ' . $this->element_id( $attr ) . ' class="jblog_postblock_' . $name . ' jeg_postblock jeg_pagination_' . $attr['pagination_mode'] . ' ' . $this->unique_id . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . ' ' . $this->get_vc_class_name() . '" data-unique="' . $this->unique_id . '">'
			. $content
			. $script
			. '</div>';

		return $output;
	}


	/**
	 * Render block element
	 *
	 * @param array $attr Array of attribute.
	 *
	 * @return mixed
	 */
	public function render_block_element( $attr ) {
		if ( isset( $attr['results'] ) ) {
			$results = $attr['results'];
		} else {
			$results = $this->build_query( $attr );
		}

		if ( ! empty( $results['result'] ) ) {
			$content = $this->render_column( $results['result'] );
		} else {
			$content = $this->empty_content();
		}

		$pagination       = $this->render_pagination( $attr, $results['next'], $results['total_page'] );
		$pagination_align = isset( $attr['pagination_align'] ) ? $attr['pagination_align'] : '';

		return '<div class="jeg_block_container">'
		       . apply_filters( 'jeg_module_block_container_extend', $content, $attr ) .
		       '</div>
				<div class="jeg_block_pagination jeg_align' . $pagination_align . '">'
		       . apply_filters( 'jeg_module_block_pagination_extend', $pagination, $attr ) .
		       '</div>';
	}


	public function render_result_element( $results, $attr ) {
		$name    = str_replace( 'jblog_block_', '', $this->id );
		$content = $this->render_result_block_element( $results, $attr );
		$script  = $this->render_script();

		$output =
			'<div ' . $this->element_id( $attr ) . ' class="jblog_postblock_' . $name . ' jeg_postblock jeg_pagination_' . $attr['pagination_mode'] . ' ' . $this->unique_id . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . ' ' . $this->get_vc_class_name() . '" data-unique="' . $this->unique_id . '">'
			. $content
			. $script
			. '</div>';

		return $output;
	}

	public function render_result_block_element($results, $attr) {
		$pagination       = $this->render_pagination( $attr, true, $attr['max_num_pages'] );
		$pagination_align = isset( $attr['pagination_align'] ) ? $attr['pagination_align'] : '';

		if ( ! empty( $results ) ) {
			$content = $this->build_column($results);
		} else {
			$content = $this->empty_content();
		}

		return '<div class="jeg_block_container">'
		       . apply_filters( 'jeg_module_block_container_extend', $content, $attr ) .
		       '</div>
				<div class="jeg_block_pagination jeg_align' . $pagination_align . '">'
		       . apply_filters( 'jeg_module_block_pagination_extend', $pagination, $attr ) .
		       '</div>';
	}

	/**
	 * Render pagination
	 *
	 * @param $attr
	 * @param bool $next
	 * @param int $total_page
	 *
	 * @return string
	 */
	protected function render_pagination( $attr, $next = false, $total = 1 ) {
		$output = '';

		if ( in_array( $attr['pagination_mode'], [ 'loadmore', 'scrollload' ] ) && $next ) {
			$output = '<div class="jeg_block_loadmore"><a href="#" data-load="' . esc_html__( 'Load More', 'jblog-elements' ) . '" data-loading="' . esc_html__( 'Loading...', 'jblog-elements' ) . '"> ' . esc_html__( 'Load More', 'jblog-elements' ) . '</a></div>';
		}

		if ( 'normal' === $attr['pagination_mode'] ) {
			if ( $total > 1 ) {
				$current = $this->get_current_page();
				$output  = $this->render_normal_navigation( $attr, $total, $current );
			}
		}

		return $output;
	}

	/**
	 * @param $attr
	 * @param $total
	 * @param $page
	 */
	protected function render_normal_navigation( $attr, $total, $current ) {
		$pagination = paginate_links( [
			'total'     => $total,
			'current'   => $current,
			'next_text' => sprintf( '<span>%s</span><i class="jblog-icon-arrow-right"></i>', esc_html__( 'Next', 'jblog-elements' ) ),
			'prev_text' => sprintf( '<i class="jblog-icon-arrow-left"></i><span>%s</span>', esc_html__( 'Previous', 'jblog-elements' ) ),
		] );

		return "<div class='jeg_pagination_normal'>{$pagination}</div>";
	}

	/**
	 * Render script part
	 *
	 * @return string
	 */
	protected function render_script() {
		if ( $this->unique_id ) {
			$attr          = $this->attribute;
			$attr['paged'] = 1;
			$attr['class'] = $this->id;

			return '<script>var ' . $this->unique_id . ' = ' . wp_json_encode( $attr ) . ';</script>';
		}
	}

	/**
	 * Ajax request handler
	 */
	public function ajax_request() {
		$attr        = $_REQUEST['data'];
		$query_param = $this->build_ajax_query( $attr );
		$results     = $this->build_query( $query_param );

		$this->set_attribute( $attr['attribute'] );

		if ( ! empty( $results['result'] ) ) {
			if ( 1 === $attr['current_page'] ) {
				$content = $this->render_column( $results['result'] );
			} else {
				$content = $this->render_column_alt( $results['result'] );
			}
		} else {
			$content = $this->empty_content();
		}

		wp_send_json( array(
			'content' => $content,
			'next'    => $results['next'],
			'prev'    => $results['prev'],
		) );
	}

	/**
	 * Build query for ajax request
	 *
	 * @param array $attr Array of attribute.
	 *
	 * @return mixed
	 */
	public function build_ajax_query( $attr ) {
		$args                = $attr['attr'];
		$args['paged']       = $attr['current_page'];
		$args['number_post'] = $attr['attr']['number_post'];

		if ( is_array( $attr['attr']['pagination_number_post'] ) ) {
			$args['pagination_number_post'] = $attr['attr']['pagination_number_post']['size'];
		} else {
			$args['pagination_number_post'] = $attr['attr']['pagination_number_post'];
		}

		return $args;
	}

	/**
	 * Render column method
	 *
	 * @param array $result
	 *
	 * @return mixed|string
	 */
	public function render_column( $result ) {
		return
			'<div class="jeg_posts jblog_ajax_flag">
                ' . $this->build_column( $result ) . '
            </div>';
	}

	/**
	 * Render alt column method (ajax request)
	 *
	 * @param array $result
	 *
	 * @return mixed|string
	 */
	public function render_column_alt( $result ) {
		return $this->build_column( $result );
	}

	/**
	 * Get Current Page
	 *
	 * @return mixed
	 */
	public function get_current_page() {
		$page  = get_query_var( 'page' ) ? get_query_var( 'page' ) : 1;
		$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

		return max( $page, $paged );
	}

	/**
	 * Build column method
	 *
	 * @param $results
	 *
	 * @return string
	 */
	abstract public function build_column( $results );
}
