<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Blockads_View
 * @package JBP\Elements\Elements\Views
 */
class Blockads_View extends View_Abstract {

	/**
	 * Render Module
	 *
	 * @param array $attr Array of attribute.
	 * @param string $column_class Class string.
	 *
	 * @return string
	 */
	public function render_element( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog_blockads ' . $this->unique_id . ' ' . $this->get_additional_class( $attr ) . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">' . $this->build_module_ads( $attr ) . '</div>';
	}

	/**
	 * Additional Class
	 *
	 * @param array $attr Array of attribute.
	 *
	 * @return string
	 */
	public function get_additional_class( $attr ) {
		$class = array();

		if ( 'googleads' !== $attr['ads_type'] ) {
			return false;
		}

		if ( 'hide' === $attr['google_desktop'] ) {
			$class[] = 'jeg_ads_hide_desktop';
		}

		if ( 'hide' === $attr['google_tab'] ) {
			$class[] = 'jeg_ads_hide_tab';
		}

		if ( 'hide' === $attr['google_phone'] ) {
			$class[] = 'jeg_ads_hide_phone';
		}

		return implode( ' ', $class );
	}

	/**
	 * Build Ads Element
	 *
	 * @param array $attr Array of attribute.
	 * @param bool $echo Return or echo result.
	 *
	 * @return string
	 */
	public function build_module_ads( $attr, $echo = false ) {
		$type     = $attr['ads_type'];
		$addclass = isset( $attr['ads_class'] ) ? $attr['ads_class'] : '';
		$ads_html = '';

		if ( 'image' === $type ) {
			$ads_tab  = $attr['ads_image_new_tab'] ? '_blank' : '_self';
			$ads_link = $attr['ads_image_link'];
			$ads_text = $attr['ads_image_alt'];

			$ads_images = array(
				'ads_image'        => $attr['ads_image'],
				'ads_image_tablet' => $attr['ads_image_tablet'],
				'ads_image_phone'  => $attr['ads_image_phone'],
			);

			foreach ( $ads_images as $key => $ads_image ) {
				if ( filter_var( $ads_images, FILTER_VALIDATE_URL ) === false ) {
					if ( isset( $ads_image['url'] ) && ! empty( $ads_image['url'] ) ) {
						$ads_images[ $key ] = $ads_image['url'];
					} else {
						$ads_images[ $key ] = wp_get_attachment_image_src( $ads_image, 'full' )[0];
					}
				}
			}

			foreach ( $ads_images as $key => $ads_image ) {
				if ( ! empty( $ads_image ) ) {
					$ads_html .= '<a href="' . $ads_link . '" target="' . $ads_tab . '" class="adlink ' . $key . ' ' . $addclass . '"><img src="' . $ads_image . '" alt="' . $ads_text . '" data-pin-no-hover="true"></a>';
				}
			}
		}

		if ( 'shortcode' === $type ) {
			$shortcode = $attr['shortcode'];
			$ads_html  = '<div class="' . $addclass . '">' . do_shortcode( $shortcode ) . '</div>';
		}

		if ( 'code' === $type ) {
			$attr['content'] = isset( $attr['code'] ) ? $attr['code'] : $attr['content'];
			$code            = empty( $this->content ) ? $attr['content'] : $this->content;
			$ads_html        = '<div class="' . $addclass . '">' . $code . '</div>';
		}

		if ( 'googleads' === $type ) {
			$publisherid = $attr['google_publisher_id'];
			$slotid      = $attr['google_slot_id'];

			if ( ! empty( $publisherid ) && ! empty( $slotid ) ) {
				$column = $this->manager->get_current_width();

				if ( $column >= 8 ) {
					$desktopsize_ad = array( '728', '90' );
					$tabsize_ad     = array( '468', '60' );
					$phonesize_ad   = array( '320', '50' );
				} else {
					$desktopsize_ad = array( '300', '250' );
					$tabsize_ad     = array( '300', '250' );
					$phonesize_ad   = array( '300', '250' );
				}

				$desktopsize = $attr['google_desktop'];
				$tabsize     = $attr['google_tab'];
				$phonesize   = $attr['google_phone'];

				if ( 'auto' !== $desktopsize ) {
					$desktopsize_ad = explode( 'x', $desktopsize );
				}
				if ( 'auto' !== $tabsize ) {
					$tabsize_ad = explode( 'x', $tabsize );
				}
				if ( 'auto' !== $phonesize ) {
					$phonesize_ad = explode( 'x', $phonesize );
				}

				$randomstring = jblog_generate_random_string();
				$ad_style     = '';

				if ( 'hide' !== $desktopsize && is_array( $desktopsize_ad ) && isset( $desktopsize_ad['0'] ) && isset( $desktopsize_ad['1'] ) ) {
					$ad_style .= ".adsslot_{$randomstring}{ width:{$desktopsize_ad[0]}px !important; height:{$desktopsize_ad[1]}px !important; }\n";
				}
				if ( 'hide' !== $tabsize && is_array( $tabsize_ad ) && isset( $tabsize_ad['0'] ) && isset( $tabsize_ad['1'] ) ) {
					$ad_style .= "@media (max-width:1199px) { .adsslot_{$randomstring}{ width:{$tabsize_ad[0]}px !important; height:{$tabsize_ad[1]}px !important; } }\n";
				}
				if ( 'hide' !== $phonesize && is_array( $phonesize_ad ) && isset( $phonesize_ad['0'] ) && isset( $phonesize_ad['1'] ) ) {
					$ad_style .= "@media (max-width:767px) { .adsslot_{$randomstring}{ width:{$phonesize_ad[0]}px !important; height:{$phonesize_ad[1]}px !important; } }\n";
				}

				$ads_html .=
					'<div class="{$addclass}">
                        <style type="text/css" scoped>
                            ' . $ad_style . '
                        </style>
                        <ins class="adsbygoogle adsslot_' . $randomstring . '" style="display:inline-block;" data-ad-client="' . $publisherid . '" data-ad-slot="' . $slotid . '"></ins>
                        <script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                        <script>(adsbygoogle = window.adsbygoogle || []).push({});</script>
                    </div>';
			}
		}

		$bottom_text = $attr['ads_bottom_text'];

		if ( $bottom_text ) {
			$ads_text_html = esc_html__( 'ADVERTISEMENT', 'jblog-elements' );
			$ads_html      = $ads_html . '<div class="ads_text">' . $ads_text_html . '</div>';
		}

		$ads_html = '<div class="ads_wrapper">' . $ads_html . '</div>';

		if ( $echo ) {
			echo jeg_sanitize( $ads_html );
		}

		return $ads_html;
	}
}
