<?php

namespace JBP\Elements\Elements\Views;

use JBP\Elements\Util\Video_Thumbnail;

/**
 * Class Blocklink_View
 * @package JBP\Elements\Elements\Views
 */
class Blocklink_View extends View_Abstract {

	/**
	 * Render Module
	 *
	 * @param array $attr Array of attribute.
	 * @param string $column_class Class string.
	 *
	 * @return string
	 */
	public function render_element( $attr, $column_class ) {

		$newtab = ( $attr['newtab'] ) ? 'target="_blank"' : '';

		if ( isset( $attr['image']['url'] ) && ! empty( $attr['image']['url'] ) ) {
			$image_bg = $attr['image']['url'];
		} else {
			$image_bg = wp_get_attachment_image_src( $attr['image'], '1140x570' )[0];
		}

		$video_type = Video_Thumbnail::instance()->get_video_provider( $attr['video_url'] );
		$video_id   = Video_Thumbnail::instance()->get_video_id( $attr['video_url'] );

		$video = '';

		if ( $attr['use_video_bg'] && 'youtube' === $video_type ) {
			$video = '<div class="jeg_videowrapper"><div class="jeg_videobg" data-youtubeid="' . $video_id . '"></div></div>';
			$this->load_youtube_api();
		}

		$second_title = !empty($attr['second_title']) ? "<span>". $attr['second_title'] ."</span>" : "";

		$output =
			'<div ' . $this->element_id( $attr ) . ' class="jblog_blocklink ' . $column_class . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
                <a href="' . $attr['title_url'] . '" ' . $newtab . '>
                    <div class="jeg_block_container">
                        <div class="jeg_block_bg">
                            <div class="bg" style="background-image:url(' . $image_bg . ')"></div>
                            ' . $video . '
                        </div>
                        <div class="jeg_block_content">
                            <div>
                                <h3>' . $attr['first_title'] . '</h3>
                                '. $second_title .'
                            </div>
                        </div>
                    </div>
                </a>
            </div>';

		return $output;
	}

	/**
	 * Enqueue YouTube API
	 */
	public function load_youtube_api() {
		// use VC youtube API if loaded.
		if ( ! wp_script_is( 'vc_youtube_iframe_api_js', 'enqueued' ) ) {
			wp_enqueue_script( 'youtube_api_js', '//www.youtube.com/iframe_api', null, JBP_ELEMENTS_VERSION, false );
		}
	}
}
