<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Hero_1_View
 * @package JBP\Elements\Elements\Views
 */
class Hero_1_View extends Hero_View_Abstract {

	/**
	 * Render block element method
	 *
	 * @param array $attr
	 * @param string $column_class
	 *
	 * @return mixed|string
	 */
	public function render_element( $attr, $column_class ) {
		$attr['jblog-post-comment'] = 1;

		$this->margin = isset( $attr['hero_margin']['size'] ) ? $attr['hero_margin']['size'] : $attr['hero_margin'];

		if ( isset( $attr['result'] ) ) {
			$results = $attr['result'];
		} else {
			if ( $attr['link'] ) {
				$attr['number_post'] = 3;
			}

			$results = $this->build_query( $attr );
			$results = $results['result'];
		}

		if ( ! empty( $results ) ) {
			if ( isset( $attr['link'] ) && $attr['link'] ) {
				$color             = $attr['color'] ? 'style="color:' . $attr['color'] . ';border-color: ' . $attr['color'] . ' ;"' : '';
				$this->bgcolor     = $attr['bgcolor'];
				$this->custom_link = '<a href="' . $attr['url'] . '"><span ' . $color . '>' . $attr['label'] . '</span></a>';
			}

			$style      = $this->get_style( $attr );
			$content    = $this->content( $results );
			$margin     = '0 0 -' . $this->margin . 'px -' . $this->margin . 'px;';
			$hero_style = isset( $attr['hero_style'] ) ? $attr['hero_style'] : 'jblog_hero_style_1';
			$output     =
				'<div ' . $this->element_id( $attr ) . ' class="jblog_hero jblog_hero_1 ' . $hero_style . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<div class="jeg_heroblock_wrapper" style="margin:' . $margin . '">
						' . $style . $content . '
					</div>
                </div>';

			return $output;
		} else {
			return $this->empty_content();
		}
	}

	/**
	 * Render block type 1
	 *
	 * @param $post
	 *
	 * @return string
	 */
	protected function render_block_type_1( $post ) {
		$padding = '0 0 ' . $this->margin . 'px ' . $this->margin . 'px;';

		if ( $post ) {
			$primary_category = $this->get_primary_category( $post->ID );
			$image            = $this->get_thumbnail( $post->ID, 'jeg-750x536' );

			$output =
				'<article ' . jeg_post_class( 'jeg_post jeg_hero_item_1', $post->ID ) . ' style="padding:' . $padding . '">
                    <div class="jeg_block_container">
                        ' . jblog_edit_post( $post->ID ) . '
                        <div class="jeg_thumb">
                            <a href="' . get_the_permalink( $post ) . '" >' . $image . '</a>
                        </div>
                        <div class="jeg_postblock_content">
                            <div class="jeg_post_category">' . $primary_category . '</div>
                            <div class="jeg_post_info">
                                <h3 class="jeg_post_title">
                                    <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                                </h3>
                                ' . $this->post_meta_1( $post ) . '
                            </div>
                        </div>
                    </div>
                </article>';

			return $output;
		} else {
			$output = '<article class="jeg_post jeg_hero_item_1 jeg_hero_empty" style="padding:' . $padding . '">
	                    <div class="jeg_block_container"></div>
	                </article>';

			return $output;
		}
	}

	/**
	 * Render block type 2
	 *
	 * @param $post
	 *
	 * @return string
	 */
	protected function render_block_type_2( $post, $index ) {
		$padding = '0 0 ' . $this->margin . 'px ' . $this->margin . 'px;';

		if ( 4 === $index && $this->custom_link ) {
			$bgcolor = ( $this->bgcolor ) ? 'style="background-color:' . $this->bgcolor . ';"' : '';

			return '<article class="jeg_post jeg_hero_item_' . $index . ' jeg_hero_empty" style="padding:' . $padding . '">
	                    <div class="jeg_block_container custom-link" ' . $bgcolor . '>' . $this->custom_link . '</div>
	                </article>';
		}

		if ( $post ) {
			$primary_category = $this->get_primary_category( $post->ID );
			$image            = $this->get_thumbnail( $post->ID, 'jeg-featured-750' );

			$output =
				'<article ' . jeg_post_class( 'jeg_post jeg_hero_item_' . $index, $post->ID ) . ' style="padding:' . $padding . '">
                    <div class="jeg_block_container">
                        ' . jblog_edit_post( $post->ID ) . '
                        <div class="jeg_thumb">
                            <a href="' . get_the_permalink( $post ) . '" >' . $image . '</a>
                        </div>
                        <div class="jeg_postblock_content">
                            <div class="jeg_post_category">' . $primary_category . '</div>
                            <div class="jeg_post_info">
                                <h3 class="jeg_post_title">
                                    <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                                </h3>
                                ' . $this->post_meta_1( $post ) . '
                            </div>
                        </div>
                    </div>
                </article>';

			return $output;
		} else {
			$output = '<article class="jeg_post jeg_hero_item_' . $index . ' jeg_hero_empty" style="padding:' . $padding . '">
	                    <div class="jeg_block_container"></div>
	                </article>';

			return $output;
		}
	}

	/**
	 * Handle the block type
	 *
	 * @param $results
	 *
	 * @return string
	 */
	protected function content( $results ) {
		$first_block  = $this->render_block_type_1( $results[0] );
		$second_block = '';

		for ( $i = 2; $i <= count( $results ); $i ++ ) {
			$item         = isset( $results[ $i - 1 ] ) ? $results[ $i - 1 ] : '';
			$second_block .= $this->render_block_type_2( $item, $i );
		}

		if ( isset( $this->attribute['link'] ) && $this->attribute['link'] && 3 === count( $results ) ) {
			$second_block .= $this->render_block_type_2( '', 4 );
		}

		$content =
			$first_block . '
            <div class="jeg_heroblock_scroller">
                ' . $second_block . '
            </div>';

		return $content;
	}
}
