<?php

namespace JBP\Elements\Elements\Views;

use Jeg\Element\Image\Image_Background_Load;

/**
 * Class Hero_View_Abstract
 * @package JBP\Elements\Elements\Views
 */
abstract class Hero_View_Abstract extends View_Abstract {

	/**
	 * Margin
	 *
	 * @var int
	 */
	protected $margin = 0;

	/**
	 * Custom link
	 *
	 * @var bool
	 */
	protected $custom_link = false;

	/**
	 * Text color
	 *
	 * @var bool
	 */
	protected $color = false;

	/**
	 * Background color
	 *
	 * @var bool
	 */
	protected $bgcolor = false;

	/**
	 * Build hero style
	 *
	 * @param $attr
	 *
	 * @return string
	 */
	public function get_style( $attr ) {
		$style = '';

		if ( ! empty( $attr['height_desktop'] ) ) {
			$height = $this->remove_px( $attr['height_desktop'] );
			$style  .= "@media only screen and (min-width: 1025px) { .jblog_hero.{$this->unique_id} .jeg_heroblock_wrapper{ height: {$height}px; } }";
		}

		if ( ! empty( $attr['height_1024'] ) ) {
			$height = $this->remove_px( $attr['height_1024'] );
			$style  .= "@media only screen and (max-width: 1024px) and (min-width: 769px) { .jblog_hero.{$this->unique_id} .jeg_heroblock_wrapper{ height: {$height}px; } }";
		}

		if ( ! empty( $attr['height_768'] ) ) {
			$height = $this->remove_px( $attr['height_768'] );
			$style  .= "@media only screen and (max-width: 768px) and (min-width: 668px) { .jblog_hero.{$this->unique_id} .jeg_heroblock_wrapper{ height: {$height}px; } }";
		}

		if ( ! empty( $attr['height_667'] ) ) {
			$height = $this->remove_px( $attr['height_667'] );
			$style  .= "@media only screen and (max-width: 667px) and (min-width: 569px) { .jblog_hero.{$this->unique_id} .jeg_heroblock_wrapper{ height: {$height}px; } }";
		}

		if ( ! empty( $attr['height_568'] ) ) {
			$height = $this->remove_px( $attr['height_568'] );
			$style  .= "@media only screen and (max-width: 568px) and (min-width: 481px) { .jblog_hero.{$this->unique_id} .jeg_heroblock_wrapper{ height: {$height}px; } }";
		}

		if ( ! empty( $attr['height_480'] ) ) {
			$height = $this->remove_px( $attr['height_480'] );
			$style  .= "@media only screen and (max-width: 480px) { .jblog_hero.{$this->unique_id} .jeg_heroblock_wrapper{ height: {$height}px; } }";
		}

		if ( ! empty( $style ) ) {
			$style = '<style>' . $style . '</style>';
		}

		return $style;
	}

	/**
	 * Remove px
	 *
	 * @param $string
	 *
	 * @return mixed
	 */
	public function remove_px( $string ) {
		return str_replace( 'px', '', $string );
	}


	/**
	 * Get post thumbnail
	 *
	 * @param int $id
	 * @param string $size
	 *
	 * @return mixed|string
	 */
	public function get_thumbnail( $id, $size ) {
		$image = new Image_Background_Load();

		return $image->single_hero_image( $id, $size );
	}
}
