<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Post_Author_View
 * @package JBP\Elements\Elements\Views
 */
class Post_Author_View extends Post_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		$post_id = get_the_ID();
		$post    = get_post( $post_id );

		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-author-box style-' . $attr['style'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					' . $this->render_content( $post_id, $post->post_author ) . '
				</div>';
	}

	/**
	 * Render content
	 *
	 * @param $post_id
	 * @param $author
	 *
	 * @return string
	 */
	public function render_content( $post_id = null, $author ) {
		return
			'<div class="jblog-author-img">
                ' . get_avatar( get_the_author_meta( 'ID', $author ), 100, null, get_the_author_meta( 'display_name', $author ) ) . '
            </div>
            <div class="jblog-author-content">
                <div class="jblog-author-name">
                    <span>' . esc_html__( 'Author', 'jblog-elements' ) . '</span>
                    <a href="' . get_author_posts_url( $author ) . '">' . get_the_author_meta( 'display_name', $author ) . '</a>
                </div>
                <p class="jblog-author-desc">' . get_the_author_meta( 'description', $author ) . '</p>
            </div>
            ' . apply_filters( 'jblog_single_author_box_socials', '', $post_id );
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-author-box style-' . $attr['style'] . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					' . $this->render_content( null, get_current_user_id() ) . '
				</div>';
	}
}
