<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Post_Category_View
 * @package JBP\Elements\Elements\Views
 */
class Post_Category_View extends Post_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-category-elements jblog-post-category ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">' . $this->render_content() . '</div>';
	}

	/**
	 * Render content
	 *
	 * @return string
	 */
	public function render_content() {
		if ( has_category() ) {
			return jblog_get_post_category( get_the_ID() );
		}
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-category-elements jblog-post-category ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<a href="#" class="category-wordpress">WordPres</a>
					<a href="#" class="category-plugin">Plugin</a>
				</div>';
	}
}
