<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Post_Comment_View
 * @package JBP\Elements\Elements\Views
 */
class Post_Comment_View extends Post_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-comment-elements ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">' . $this->render_content( $attr ) . '</div>';
	}

	/**
	 * Render content
	 *
	 * @return string
	 */
	public function render_content( $attr ) {
		$output = '';

		if ( $attr['toggle'] ) {
			$number        = get_comments_number();
			$full          = $attr['full'] ? 'full' : '';
			$show_label    = sprintf( _n( 'Show Comment (%d)', 'Show Comments (%d)', $number, 'jblog' ), $number );
			$hide_label    = sprintf( _n( 'Hide Comment (%d)', 'Hide Comments (%d)', $number, 'jblog' ), $number );
			$default_label = 'hide' === $attr['toggle_default'] ? $show_label : $hide_label;

			$output .= '<div class="jblog-post-toggle-comment ' . $attr['toggle_default'] . ' ' . $full . '" data-show="' . $show_label . '" data-hide="' . $hide_label . '"><span>' . $default_label . '</span><i class="fa fa-angle-up"></i></div>';
		}

		$toggle  = 'hide' === $attr['toggle_default'] ? 'toggle-comment' : '';

		ob_start();
		comments_template();

		return $output . '<div class="jblog-post-comment style-' . esc_attr( $attr['style'] ) . ' ' . esc_attr( $toggle ) . '">' . ob_get_clean() . '</div>';
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return $this->render_frontend( $attr, $column_class );
	}
}
