<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Post_Featured_View
 * @package JBP\Elements\Elements\Views
 */
class Post_Featured_View extends Post_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		$post_id = get_the_ID();

		if ( has_post_thumbnail( $post_id ) ) {
			$thumbnail = apply_filters( 'jeg_image_thumbnail_unwrap', $post_id, $attr['image_size'] );

			return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-featured-elements jblog-post-featured featured-image caption-' . $attr['caption'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">' . $thumbnail . '</div>';
		}
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		switch ( $attr['image_size'] ) {
			case 'jeg-750x536' :
				$size = '715';
				break;
			case 'jeg-800x400' :
			case 'jeg-1140x570' :
				$size = '500';
				break;
			default:
				$size = '1000';
				break;
		}

		$label = [
			'jeg-800x400'       => esc_attr__( '750x375', 'jblog-elements' ),
			'jeg-1140x570'      => esc_attr__( '1140x570', 'jblog-elements' ),
			'jeg-750x536'       => esc_attr__( '750x536', 'jblog-elements' ),
			'jeg-featured-750'  => esc_attr__( 'Width 750', 'jblog-elements' ),
			'jeg-featured-1140' => esc_attr__( 'Width 1140', 'jblog-elements' ),
			'full'              => esc_attr__( 'Fullwidth', 'jblog-elements' ),
		];

		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-featured-elements jblog-post-featured featured-image editor caption-' . $attr['caption'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<a href=""#">
                        <div class="thumbnail-container animate-lazy size-' . $size . '">
                            <span>' . esc_html__( 'Image with size : ', 'jblog-elements' ) . '<strong>' . $label[ $attr['image_size'] ] . '</strong></span>
                        </div>
                        <p class="wp-caption-text">' . esc_html__( 'Image caption will goes here.', 'jblog-elements' ) . '</p>
                    </a>
				</div>';
	}
}
