<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Post_Meta_View
 * @package JBP\Elements\Elements\Views
 */
class Post_Meta_View extends Post_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-meta-elements jblog-post-meta style-' . $attr['meta_style'] . ' ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">' . $this->render_content( $attr ) . '</div>';
	}

	/**
	 * Render content
	 *
	 * @return string
	 */
	public function render_content( $attr ) {
		$output  = '';
		$post    = get_post( get_the_ID() );
		$avatar  = get_avatar( get_the_author_meta( 'ID', $post->post_author ), 45, null, get_the_author_meta( 'display_name', $post->post_author ) );
		$author  = $this->build_post_author( $post );
		$date    = $this->build_post_date( $attr, $post );
		$read    = $this->build_post_read( $post );
		$comment = $this->build_post_comment( $post );


		if ( '1' === $attr['meta_style'] ) {

			if ( $attr['author'] && $attr['author_image'] ) {
				$output .= $avatar;
			}

			if ( $attr['author'] ) {
				$output .= $author;
			}

			if ( $attr['date'] ) {
				$output .= $date;
			}

			if ( $attr['read'] ) {
				$output .= $read;
			}

			if ( $attr['comment'] ) {
				$output .= $comment;
			}

		} else {
			if ( ! $attr['author_image'] || ! $attr['author'] ) {
				$avatar = '';
			}

			if ( ! $attr['author'] ) {
				$author = '';
			}

			if ( ! $attr['date'] ) {
				$date = '';
			}

			if ( ! $attr['read'] ) {
				$read = '';
			}

			if ( ! $attr['comment'] ) {
				$comment = '';
			}

			$output = $avatar .
			          '<div class="jblog-meta-group">
	                        ' . $author . '
                            <div class="jblog-meta-bottom">
	                        	' . $date . $read . $comment . '
                            </div>
                        </div>';
		}

		return $output;
	}

	/**
	 * Build post comment
	 *
	 * @param $post
	 *
	 * @return string
	 */
	public function build_post_comment( $post ) {
		$comment = jblog_get_comments_number( $post->ID );

		return '<div class="jblog-meta-comment">
					<a href=' . jblog_get_respond_link( $post->ID ) . '>
		                <i class="jblog-icon-comment"></i>
		                <span>' . $comment . '</span>
		            </a>
		        </div>';
	}

	/**
	 * Build post read time
	 *
	 * @param $post
	 *
	 * @return string
	 */
	public function build_post_read( $post ) {
		$content = $post->post_content;
		$wpm     = 300;
		$output  = '';

		if ( $content && $wpm ) {
			$content    = strip_shortcodes( $content );
			$word_count = str_word_count( $content );
			$word_count = ceil( $word_count / $wpm );

			if ( ! $word_count ) {
				$word_count = 0;
			}

			$output = '<span>' . $word_count . ' ' . esc_html__( 'min read', 'jblog-elements' ) . '</span>';
		}

		return '<div class="jblog-meta-read">' . $output . '</div>';
	}

	/**
	 * Build post date
	 *
	 * @param $attr
	 * @param $post
	 *
	 * @return string
	 */
	public function build_post_date( $attr, $post ) {
		if ( 'both' === $attr['date_type'] ) {
			$output = $this->get_post_date( $post, $attr['date_format'], 'published', $attr['date_custom'] );
			$output .= esc_html__( ' - Updated on ', 'jblog' );
			$output .= $this->get_post_date( $post, $attr['date_format'], 'modified', $attr['date_custom'] );
		} else {
			$output = $this->get_post_date( $post, $attr['date_format'], $attr['date_type'], $attr['date_custom'] );
		}

		return '<div class="jblog-meta-date">' . $output . '</div>';
	}

	/**
	 * Build post author
	 *
	 * @param $post
	 *
	 * @return string
	 */
	public function build_post_author( $post ) {
		return '<div class="jblog-meta-author">' . jblog_get_post_author( $post ) . '</div>';
	}

	/**
	 * Build post author meta style 2
	 *
	 * @param $post
	 * @param $date
	 *
	 * @return string
	 */
	public function get_post_author( $post, $date ) {
		$avatar = get_avatar( get_the_author_meta( 'ID', $post->post_author ), 45, null, get_the_author_meta( 'display_name', $post->post_author ) );
		$info   =
			'<span class="author-name">
                <span class="by">' . esc_html__( 'By', 'jblog-elements' ) . '</span> <a href="' . esc_url( get_author_posts_url( $post->post_author ) ) . '">' . get_the_author_meta( 'display_name', $post->post_author ) . '</a>
            </span>';

		if ( $date ) {
			$format = get_theme_mod( 'jblog_date_format', 'default' );
			$type   = get_theme_mod( 'jblog_date_type', 'published' );
			$custom = get_theme_mod( 'jblog_date_custom' );

			$info .= '<span class="author-date">' . $this->get_post_date( $post, $format, $type, $custom ) . '</span>';
		}

		return $avatar . '<span class="author-info ' . $date . '">' . $info . '</span>';
	}

	/**
	 * Get post date
	 *
	 * @param $post
	 * @param $format
	 * @param $type
	 * @param $custom
	 *
	 * @return false|string
	 */
	public function get_post_date( $post, $format, $type, $custom ) {
		if ( 'ago' === $format ) {
			$output = jblog_get_post_ago_time( $type, $post );
		} elseif ( 'custom' === $format ) {
			$output = jblog_get_post_date( $custom, $post, $type );
		} else {
			$output = jblog_get_post_date( null, $post, $type );
		}

		return $output;
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-meta-elements jblog-post-meta style-' . $attr['meta_style'] . ' ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					' . $this->render_content( $attr ) . '
				</div>';
	}
}
