<?php

namespace JBP\Elements\Elements\Views;

use Jeg\Element\Element;

/**
 * Class Post_Related_View
 * @package JBP\Elements\Elements\Views
 */
class Post_Related_View extends Post_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-related ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">' . $this->render_content( $attr ) . '</div>';
	}

	/**
	 * Render content
	 *
	 * @return string
	 */
	public function render_content( $attr ) {
		$post_id  = get_the_ID();
		$category = $post_tag = [];
		$element  = Element::instance();
		$instance = $element->manager->get_element_view( 'jblog_block_' . $attr['block'] );

		if ( in_array( $attr['filter'], [ 'category', 'both' ] ) ) {
			$cats = get_the_category( $post_id );
			if ( $cats ) {
				foreach ( $cats as $cat ) {
					$category[] = $cat->term_id;
				}
			}
		}

		if ( in_array( $attr['filter'], [ 'tag', 'both' ] ) ) {
			$tags = get_the_tags( $post_id );
			if ( $tags ) {
				foreach ( $tags as $tag ) {
					$post_tag[] = $tag->term_id;
				}
			}
		}

		$args['number_post']      = $attr['number_post'];
		$args['posts_per_page']   = $attr['number_post'];
		$args['include_tag']      = implode( ',', $post_tag );
		$args['include_category'] = implode( ',', $category );
		$args['exclude_post']     = $post_id;
		$args['pagination_mode']  = 'disable';
		$args['sort_by']          = 'latest';
		$args['post_type']        = 'post';
		$args['post_offset']      = 0;
		$args['el_class']         = '';

		$content = $instance->render_element( $args, '' );

		if ( $content ) {
			return '<div class="jblog-post-related">
		                <h4 class="related-title">' . $attr['label'] . '</h4>
		                ' . $content . '
		            </div>';
		}

	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return $this->render_frontend( $attr, $column_class );
	}
}
