<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Post_Sequence_View
 * @package JBP\Elements\Elements\Views
 */
class Post_Sequence_View extends Post_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-prevnext style-' . $attr['style'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">' . $this->render_content( $attr, get_previous_post(), get_next_post() ) . '</div>';
	}

	/**
	 * Render content
	 *
	 * @return string
	 */
	public function render_content( $attr, $prev_post, $next_post ) {
		if ( $prev_post || $next_post ) {
			$date_format = get_theme_mod( 'jblog_date_format', 'default' );
			$date_type   = get_theme_mod( 'jblog_date_type', 'published' );
			$date_custom = get_theme_mod( 'jblog_date_custom' );
			$prev_output = $next_output = '';

			if ( $prev_post ) {
				$prev_output = $this->get_prev_post( $prev_post, $attr['style'], $date_format, $date_type, $date_custom );
			}

			if ( $next_post ) {
				$next_output = $this->get_next_post( $next_post, $attr['style'], $date_format, $date_type, $date_custom );
			}

			return '<div class="post-prev">' . $prev_output . '</div><div class="post-next">' . $next_output . '</div>';
		}
	}

	/**
	 * Get previous post
	 *
	 * @param $prev_post
	 * @param $style
	 * @param $format
	 * @param $type
	 * @param $custom
	 *
	 * @return string
	 */
	public function get_prev_post( $prev_post, $style, $format, $type, $custom ) {
		$label = '1' === $style ? '<i class="jblog-icon-arrow-left"></i>' : esc_html__( 'prev post', 'jblog-elements' );
		$label = '<a href="' . get_the_permalink( $prev_post ) . '">' . $label . '</a>';

		$output =
			'<div class="jblog-post-category">' . jblog_primary_category( $prev_post ) . '</div>
            <h3 class="jblog-post-title"><a href="' . get_the_permalink( $prev_post ) . '">' . get_the_title( $prev_post ) . '</a></h3>
            <div class="jblog-post-meta">
                <div class="jblog-meta-author">' . jblog_get_post_author( $prev_post ) . '</div>
                <div class="jblog-meta-date">' . $this->get_post_date( $prev_post, $format, $type, $custom ) . '</div>
            </div>';

		$output = $label . $output;

		return $output;
	}

	/**
	 * Get next post
	 *
	 * @param $next_post
	 * @param $style
	 * @param $format
	 * @param $type
	 * @param $custom
	 *
	 * @return string
	 */
	public function get_next_post( $next_post, $style, $format, $type, $custom ) {
		$label = '1' === $style ? '<i class="jblog-icon-arrow-right"></i>' : esc_html__( 'next post', 'jblog-elements' );
		$label = '<a href="' . get_the_permalink( $next_post ) . '">' . $label . '</a>';

		$output =
			'<div class="jblog-post-category">' . jblog_primary_category( $next_post ) . '</div>
            <h3 class="jblog-post-title"><a href="' . get_the_permalink( $next_post ) . '">' . get_the_title( $next_post ) . '</a></h3>
            <div class="jblog-post-meta">
                <div class="jblog-meta-author">' . jblog_get_post_author( $next_post ) . '</div>
                <div class="jblog-meta-date">' . $this->get_post_date( $next_post, $format, $type, $custom ) . '</div>
            </div>';

		$output = $label . $output;

		return $output;
	}

	/**
	 * Get post date
	 *
	 * @param $post
	 * @param $format
	 * @param $type
	 * @param $custom
	 *
	 * @return false|string
	 */
	public function get_post_date( $post, $format, $type, $custom ) {
		if ( 'ago' === $format ) {
			$output = jblog_get_post_ago_time( $type, $post );
		} elseif ( 'custom' === $format ) {
			$output = jblog_get_post_date( $custom, $post, $type );
		} else {
			$output = jblog_get_post_date( null, $post, $type );
		}

		return $output;
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		$posts     = get_posts( 'orderby=rand&numberposts=2&post_type=post' );
		$post_prev = $posts[0] ? $posts[0] : null;
		$post_next = $posts[1] ? $posts[1] : null;

		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-prevnext style-' . $attr['style'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">' . $this->render_content( $attr, $post_prev, $post_next ) . '</div>';
	}
}
