<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Post_Subtitle_View
 * @package JBP\Elements\Elements\Views
 */
class Post_Subtitle_View extends Post_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		$subtitle = wp_kses( get_post_meta( get_the_ID(), 'jblog-post-subtitle', true ), wp_kses_allowed_html() );

		return '<div ' . $this->element_id( $attr ) . ' class="jblog_post_subtitle ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<h3 class="jblog-post-subtitle">' . $subtitle . '</h3>
				</div>';
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog_post_subtitle ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<h3 class="jblog-post-subtitle">' . esc_html__( 'This is dummy post subtitle', 'jblog-elements' ) . '</h3>
				</div>';
	}
}
