<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Post_Tag_View
 * @package JBP\Elements\Elements\Views
 */
class Post_Tag_View extends Post_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-tag-elements jblog-post-tag style-' . $attr['style'] . ' ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">' . $this->render_content( $attr ) . '</div>';
	}

	/**
	 * Render content
	 *
	 * @return string
	 */
	public function render_content( $attr ) {
		if ( has_tag() ) {
			$label = $attr['label'] ? '<span>' . $attr['label'] . '</span>' : '';

			return $label . get_the_tag_list( '', '', '' );
		}
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		$label = $attr['label'] ? '<span>' . $attr['label'] . '</span>' : '';

		return '<div ' . $this->element_id( $attr ) . ' class="jblog-post-tag-elements jblog-post-tag style-' . $attr['style'] . ' ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					' . $label . '
					<a href="#" rel="tag">Blog</a>
					<a href="#" rel="tag">Story</a>
					<a href="#" rel="tag">Article</a>
					<a href="#" rel="tag">Post</a>
				</div>';
	}
}
