<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Post_Title_View
 * @package JBP\Elements\Elements\Views
 */
class Post_Title_View extends Post_View_Abstract {

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_frontend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog_post_title ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<h1 class="jblog-post-title">' . get_the_title() . '</h1>
				</div>';
	}

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public function render_backend( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog_post_title ' . $attr['align'] . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">
					<h1 class="jblog-post-title">' . esc_html__( 'This is dummy post title and will be replaced with the actual post title on frontend', 'jblog-elements' ) . '</h1>
				</div>';
	}
}
