<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Post_View_Abstract
 * @package JBP\Elements\Elements\Views
 */
abstract class Post_View_Abstract extends View_Abstract {

	/**
	 * Render post element method
	 *
	 * @param array $attr
	 * @param string $column_class
	 *
	 * @return mixed|string
	 */
	public function render_element( $attr, $column_class ) {
		if ( $this->is_on_editor() ) {
			return $this->render_backend( $attr, $column_class );
		} else {
			return $this->render_frontend( $attr, $column_class );
		}
	}

	/**
	 * Editor page checking
	 *
	 * @return bool
	 */
	protected function is_on_editor() {
		return jeg_is_frontend_vc() || jeg_is_editor_elementor();
	}

	/**
	 * Render element for frontend site
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public abstract function render_frontend( $attr, $column_class );

	/**
	 * Render element for backend editor
	 *
	 * @param $attr
	 * @param $column_class
	 *
	 * @return mixed
	 */
	public abstract function render_backend( $attr, $column_class );
}
