<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Slider_2_View
 * @package JBP\Elements\Elements\Views
 */
class Slider_2_View extends Slider_View_Abstract {

	/**
	 * Slider content
	 *
	 * @param $results
	 *
	 * @return mixed
	 */
	public function content( $results ) {
		$content = '';
		foreach ( $results as $key => $post ) {
			$primary_category = $this->get_primary_category( $post->ID );
			$image            = $this->get_thumbnail( $post->ID, 'jeg-370x370' );
			$author_url       = get_author_posts_url( $post->post_author );
			$author_name      = get_the_author_meta( 'display_name', $post->post_author );

			$content .=
				'<div class="slide_item">
                    ' . jblog_edit_post( $post->ID ) . '
                    <a href="' . get_permalink( $post ) . '" class="slide_img">' . $image . '</a>
                    <div class="slide_caption">
                        <div class="jeg_post_category">
                            ' . $primary_category . '
                        </div>
                        <h3 class="jeg_post_title">
                            <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                        </h3>
                        <div class="jeg_post_meta">
                        	<div class="jeg_meta_author">
                        		' . get_avatar( get_the_author_meta( 'ID', $post->post_author ), 30, null, get_the_author_meta( 'display_name', $post->post_author ) ) . '
				                <span class="by">' . esc_html__( 'by', 'jblog-elements' ) . '</span>
				                <a href="' . $author_url . '">' . $author_name . '</a>
				            </div>
				            <div class="jeg_meta_date">' . $this->format_date( $post ) . '</div>
						</div>
                    </div>
                </div>';
		}

		return $content;
	}
}
