<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Slider_3_View
 * @package JBP\Elements\Elements\Views
 */
class Slider_3_View extends Slider_View_Abstract {

	/**
	 * Slider content
	 *
	 * @param $results
	 *
	 * @return mixed
	 */
	public function content( $results ) {
		$content = array(
			'thumbs'  => '',
			'content' => ''
		);

		foreach ( $results as $key => $post ) {
			$primary_category = $this->get_primary_category( $post->ID );

			$content['thumbs']  .= $this->get_thumbnail( $post->ID, 'jeg-1140x570' );
			$content['content'] .=
				'<div data-index="' . $key . '" class="slide_caption">
					<div class="jeg_post_category">
						<span>' . $primary_category . '</span>
	                </div>
	                <h3 class="jeg_post_title">
	                    <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
	                </h3>
	                <div class="jeg_post_excerpt">
		                <p>' . $this->get_excerpt( $post ) . '</p>
		            </div>
	                <div class="jeg_meta_readmore">
	                    <i class="jblog-icon-arrow-right"></i>
	                    <a href="' . get_the_permalink( $post ) . '" class="jeg_readmore">' . esc_html__( 'Read more', 'jblog-elements' ) . '</a>
	                </div>
				</div>';
		}

		return '<div class="jeg_slide_wrapper">
				    <div class="slide_img">' . $content['thumbs'] . '</div>
				    ' . $content['content'] . '
				</div>
			    <div class="jeg_slide_nav">
			        <div class="jeg_slide_control">
				        <button class="jeg_slide_next">
				            ' . esc_html__( 'Next', 'jblog-elements' ) . '
				            <i class="jblog-icon-arrow-right"></i>
				        </button>
				        <button class="jeg_slide_prev">
				            <i class="jblog-icon-arrow-left"></i>
				            ' . esc_html__( 'Prev', 'jblog-elements' ) . '
				        </button>
				        <div class="jeg_slide_info">1/' . count( $results ) . '</div>
				    </div>
				    <div class="jeg_slide_thumb"></div>
				</div>';
	}
}
