<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Slider_4_View
 * @package JBP\Elements\Elements\Views
 */
class Slider_4_View extends Slider_View_Abstract {

	/**
	 * Render block element method
	 *
	 * @param array $attr
	 * @param string $column_class
	 *
	 * @return mixed|string
	 */
	public function render_element( $attr, $column_class ) {
		$results = $this->build_query( $attr );
		$results = $results['result'];

		if ( ! empty( $results ) ) {
			$content        = $this->content( $results );
			$autoplay_delay = isset( $attr['autoplay_delay']['size'] ) ? $attr['autoplay_delay']['size'] : $attr['autoplay_delay'];

			$nav_text = array(
				esc_html__( 'Next', 'jblog-elements' ),
				esc_html__( 'Prev', 'jblog-elements' ),
			);

			$output =
				'<div ' . $this->element_id( $attr ) . ' class="jblog_slider ' . $this->id . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '" data-autoplay="' . $attr['enable_autoplay'] . '" data-delay="' . $autoplay_delay . '" data-nav-text=' . json_encode( $nav_text ) . '>' . $content . '</div>';

			return $output;
		} else {
			return $this->empty_content();
		}
	}

	/**
	 * Slider content
	 *
	 * @param $results
	 *
	 * @return mixed
	 */
	public function content( $results ) {
		$content = '';
		foreach ( $results as $key => $post ) {
			$primary_category = $this->get_primary_category( $post->ID );
			$image            = $this->get_thumbnail( $post->ID, 'full' );

			$content .=
				'<div class="slide_item">
                    ' . jblog_edit_post( $post->ID ) . '
                    <div class="jeg_slide_image">
                    	<a href="' . get_permalink( $post ) . '">' . $image . '</a>
					</div>
                    <div class="slide_content">
                    	<div class="slide_caption">
	                        <div class="jeg_post_category">
	                            ' . $primary_category . '
	                        </div>
	                        <h3 class="jeg_post_title">
	                            <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
	                        </h3>
	                        <div class="jeg_post_excerpt">
			                    <p>' . $this->get_excerpt( $post ) . '</p>
			                </div>
			                <a href="' . get_the_permalink( $post ) . '" class="jeg_readmore">' . esc_html__( 'Read more', 'jblog-elements' ) . '</a>
			            </div>
			                
		                <div class="slide_nav"> 
                        	<a href="#" class="prev">
                        		<i class="jblog-icon-angle-left"></i> Prev
                        	</a> 
                        	<span class="slide_info"></span>
                        	<a href="#" class="next">
                        		Next <i class="jblog-icon-angle-right"></i>
                        	</a> 
                        </div>
                    </div>
                </div>';
		}

		return $content;
	}
}
