<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Slider_5_View
 * @package JBP\Elements\Elements\Views
 */
class Slider_5_View extends Slider_View_Abstract {

	/**
	 * Post index
	 *
	 * @param $results
	 *
	 * @return string
	 */
	public function index( $results ) {
		$count  = count( $results );
		$output = '';

		for ($i=1; $i <= $count ; $i++) {
			if ( $i < 10 ) {
				$output .= '<span data-index=' . $i . '>0' . $i . '</span>';
			} else {
				$output .= '<span data-index=' . $i . '>' . $i . '</span>';
			}
		}

		return $output;
	}

	/**
	 * Slider content
	 *
	 * @param $results
	 *
	 * @return mixed
	 */
	public function content( $results ) {
		$content = '';
		foreach ( $results as $key => $post ) {
			$primary_category = $this->get_primary_category( $post->ID );
			$image            = $this->get_thumbnail( $post->ID, 'jeg-800x400' );

			$content .=
				'<div class="slide_item">
                    ' . jblog_edit_post( $post->ID ) . '
                    <div class="jeg_slide_image">
                    	<a href="' . get_permalink( $post ) . '">' . $image . '</a>
                        <div class="jeg_post_category">
                            ' . $primary_category . '
                        </div>
					</div>
                    <div class="slide_caption">
                        <h3 class="jeg_post_title">
                            <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                        </h3>
                    	' . $this->post_meta_1( $post ) . '
                    </div>
                    <div class="jeg_post_excerpt">
	                    <p>' . $this->get_excerpt( $post ) . '</p>
	                </div>
                </div>';
		}

		return '<div class="jeg_slide_items">' . $content . '</div>
				<div class="jeg_slide_index">' . $this->index( $results ) . '</div>';
	}
}
