<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Slider_6_View
 * @package JBP\Elements\Elements\Views
 */
class Slider_6_View extends Slider_View_Abstract {

	/**
	 * Render slider element method
	 *
	 * @param array $attr
	 * @param string $column_class
	 *
	 * @return mixed|string
	 */
	public function render_element( $attr, $column_class ) {
		$results = $this->build_query( $attr );
		$results = $results['result'];

		if ( ! empty( $results ) ) {
			$content        = $this->content( $results );
			$autoplay_delay = isset( $attr['autoplay_delay']['size'] ) ? $attr['autoplay_delay']['size'] : $attr['autoplay_delay'];

			$output =
				'<div ' . $this->element_id( $attr ) . ' class="jblog_slider ' . $this->id . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '" data-autoplay="' . $attr['enable_autoplay'] . '" data-delay="' . $autoplay_delay . '" data-dots="' . $attr['dot'] . '" data-nav="' . $attr['nav'] . '">' . $content . '</div>';

			return $output;
		} else {
			return $this->empty_content();
		}
	}

	/**
	 * Slider content
	 *
	 * @param $results
	 *
	 * @return mixed
	 */
	public function content( $results ) {
		$content = '';
		foreach ( $results as $key => $post ) {
			$primary_category = $this->get_primary_category( $post->ID );
			$image            = $this->get_thumbnail( $post->ID, 'jeg-360x480' );

			$content .=
				'<div class="slide_item">
                    ' . jblog_edit_post( $post->ID ) . '
                    <div class="jeg_slide_image">
                    	<a href="' . get_permalink( $post ) . '">' . $image . '</a>
					</div>
                    <div class="slide_caption">
                        <h3 class="jeg_post_title">
                            <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                        </h3>
                    	<div class="jeg_post_meta">
	                    	<div class="jeg_post_category">' . $primary_category . '</div>
	                    	<div class="jeg_meta_date">' . $this->format_date( $post ) . '</div>
	                    </div>
                    </div>
                </div>';
		}

		return $content;
	}
}
