<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Slider_7_View
 * @package JBP\Elements\Elements\Views
 */
class Slider_7_View extends Slider_View_Abstract {

	/**
	 * Render block element method
	 *
	 * @param array $attr
	 * @param string $column_class
	 *
	 * @return mixed|string
	 */
	public function render_element( $attr, $column_class ) {
		$results = $this->build_query( $attr );
		$results = $results['result'];

		if ( ! empty( $results ) ) {
			$content        = $this->content( $results );
			$autoplay_delay = isset( $attr['autoplay_delay']['size'] ) ? $attr['autoplay_delay']['size'] : $attr['autoplay_delay'];
			$number_item    = isset( $attr['number_item']['size'] ) ? $attr['number_item']['size'] : $attr['number_item'];

			$output =
				'<div ' . $this->element_id( $attr ) . ' class="jblog_slider ' . $this->id . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '" data-autoplay="' . $attr['enable_autoplay'] . '" data-delay="' . $autoplay_delay . '" data-item="' . $number_item . '">' . $content . '</div>';

			return $output;
		} else {
			return $this->empty_content();
		}
	}

	/**
	 * Slider content
	 *
	 * @param $results
	 *
	 * @return mixed
	 */
	public function content( $results ) {
		$content = '';
		foreach ( $results as $key => $post ) {
			$primary_category = $this->get_primary_category( $post->ID );
			$image            = $this->get_thumbnail( $post->ID, 'jeg-370x370' );
			$author_url       = get_author_posts_url( $post->post_author );
			$author_name      = get_the_author_meta( 'display_name', $post->post_author );

			$content .=
				'<div class="slide_item">
                    ' . jblog_edit_post( $post->ID ) . '
                    <div class="jeg_slide_image">
                    	<a href="' . get_permalink( $post ) . '">' . $image . '</a>
					</div>
                    <div class="slide_caption">
                    	<div class="jeg_post_category">
                            ' . $primary_category . '
                        </div>
                        <h3 class="jeg_post_title">
                            <a href="' . get_the_permalink( $post ) . '">' . get_the_title( $post ) . '</a>
                        </h3>
                        <div class="jeg_post_meta">
	                        <div class="jeg_meta_author">
				                <span class="by">' . esc_html__( 'by', 'jblog-elements' ) . '</span>
				                <a href="' . $author_url . '">' . $author_name . '</a>
				            </div>
			            </div>
                    </div>
                </div>';
		}

		return $content;
	}
}
