<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Slider_View_Abstract
 * @package JBP\Elements\Elements\Views
 */
abstract class Slider_View_Abstract extends View_Abstract {

	/**
	 * Render slider element method
	 *
	 * @param array $attr
	 * @param string $column_class
	 *
	 * @return mixed|string
	 */
	public function render_element( $attr, $column_class ) {
		$results = $this->build_query( $attr );
		$results = $results['result'];

		if ( ! empty( $results ) ) {
			$content        = $this->content( $results );
			$autoplay_delay = isset( $attr['autoplay_delay']['size'] ) ? $attr['autoplay_delay']['size'] : $attr['autoplay_delay'];

			$output =
				'<div ' . $this->element_id( $attr ) . ' class="jblog_slider ' . $this->id . ' ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '" data-autoplay="' . $attr['enable_autoplay'] . '" data-delay="' . $autoplay_delay . '">' . $content . '</div>';

			return $output;
		} else {
			return $this->empty_content();
		}
	}

	/**
	 * Slider content
	 *
	 * @param $results
	 *
	 * @return mixed
	 */
	abstract public function content( $results );
}
