<?php

namespace JBP\Elements\Elements\Views;

/**
 * Class Taxonomy_List_View
 * @package JBP\Elements\Elements\Views
 */
class Taxonomy_List_View extends View_Abstract {

	/**
	 * Render Module
	 *
	 * @param array $attr Array of attribute.
	 * @param string $column_class Class string.
	 *
	 * @return string
	 */
	public function render_element( $attr, $column_class ) {
		return '<div ' . $this->element_id( $attr ) . ' class="jblog_taxonomy_list ' . $this->unique_id . ' ' . $this->get_vc_class_name() . ' ' . $attr['el_class'] . ' ' . $this->color_scheme() . '">' . $this->build_module( $attr ) . '</div>';
	}

	/**
	 * Build element
	 *
	 * @param $attr
	 *
	 * @return string
	 */
	protected function build_module( $attr ) {
		$output = '';

		if ( isset( $attr['label'] ) && $attr['label'] ) {
			$output .= '<h3 class="jblog_block_title"><span>' . $attr['label'] . '</span></h3>';
		}

		if ( isset( $attr['taxonomy'] ) && $attr['taxonomy'] ) {
			$number_item = isset( $attr['number']['size'] ) ? $attr['number']['size'] : $attr['number'];
			$terms       = get_terms( $attr['taxonomy'], array(
				'hide_empty' => false,
				'number'     => $number_item ? $number_item : PHP_INT_MAX
			) );

			if ( $terms && is_array( $terms ) ) {
				$term_list = '';

				foreach ( $terms as $term ) {
					$term_list .= '<li><a href="' . get_term_link( $term->term_id ) . '">' . $term->name . '</a></li>';
				}

				if ( $term_list ) {
					$term_list = '<ul>' . $term_list . '</ul>';
				}

				$output .= $term_list;
			}
		}

		return $output;
	}
}
