<?php

namespace JBP\Elements\Single;

use Jeg\Form\Form_Meta_Box;

/**
 * Class Single_Options
 * @package JBP\Elements\Single
 */
class Single_Options {

	/**
	 * @var Single_Options
	 */
	private static $instance;

	/**
	 * @var string
	 */
	private static $id = 'jbp-single-post';

	/**
	 * @var string
	 */
	private static $post_type = 'post-template';

	/**
	 * @return Single_Options
	 */
	public static function instance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	/**
	 * Single_Options constructor.
	 */
	private function __construct() {
		if ( ! in_array( $GLOBALS['pagenow'], [ 'post.php', 'post-new.php' ] ) ) {
			return false;
		}

		$this->register_metabox();
	}

	/**
	 * Register metabox
	 */
	protected function register_metabox() {
		$option = [
			'id'        => self::$id,
			'title'     => esc_html__( 'Single Post Setting', 'jblog-elements' ),
			'post_type' => 'post',
			'type'      => 'normal',
			'fields'    => $this->metabox_fields(),
			'segments'  => $this->metabox_segments(),
		];

		new Form_Meta_Box( $option );
	}

	/**
	 * Set metabox segments
	 *
	 * @return array
	 */
	protected function metabox_segments() {
		$segment = [];

		$segment['default'] = [
			'name'     => esc_html__( 'Default Segment', 'jblog-elements' ),
			'priority' => 1,
		];

		return $segment;
	}

	/**
	 * Metabox field
	 *
	 * @return array
	 */
	protected function metabox_fields() {
		$fields = [];

		$fields['override'] = [
			'segment'     => 'default',
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Override Single Post Setting', 'jblog-elements' ),
			'description' => esc_html__( 'Enable this option and you will able to override the single post setting for the current post.', 'jblog-elments' ),
			'default'     => false,
		];

		$fields['single_template_custom'] = [
			'segment'     => 'default',
			'type'        => 'select',
			'title'           => esc_html__( 'Custom Post Template', 'jblog-elements' ),
			'description'     => wp_kses( sprintf( __( 'You can create custom post template from <a href="%s" target="_blank">here</a>.', 'jblog-elements' ), get_admin_url() . 'edit.php?post_type=' . self::$post_type ), wp_kses_allowed_html() ),
			'default'     => '',
			'options'     => jblog_get_all_custom_post_type( static::$post_type ),
			'dependency'  => [
				[
					'field'    => 'override',
					'operator' => '==',
					'value'    => true
				]
			]
		];

		return $fields;
	}
}
