<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       #
 * @since      1.0.0
 *
 * @package    Seo_Tracker
 * @subpackage Seo_Tracker/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Seo_Tracker
 * @subpackage Seo_Tracker/admin
 * @author     Minh <thach@gmail.com>
 */
class Seo_Tracker_Admin
{

    private $plugin_name;
    private $version;

    public function __construct($plugin_name, $version)
    {

        $this->plugin_name = $plugin_name;
        $this->version = $version;

        add_action('admin_menu', [$this, 'page_setting']);
        add_filter('seo-rank-tracker/seo-tracker.php', [$this, 'generalLinkSetting']);
    }

    public function generalLinkSetting()
    {
        return menu_page_url("seo-rank-tracker", false);
    }

    public function page_setting()
    {
        add_submenu_page(
            null,
            'Seo Rank Tracker settings',
            'Seo Rank Tracker settings',
            'manage_options',
            'seo-rank-tracker',
            [$this, 'seoRankTrackerSetting']
        );
    }

    public function seoRankTrackerSetting()
    {
        wp_enqueue_style($this->plugin_name . "_admin_css");

        $urlProcessLogin = menu_page_url('seo-tracker', false);
        $urlLogin = Seo_Tracker_Config::AUTH_URL . "?" . http_build_query([
                "app_id" => Seo_Tracker_Config::APP_ID,
                "pub" => Seo_Tracker_Config::PUB_KEY,
                "process" => $urlProcessLogin
            ]);

        if (isset($_GET['logout']) && $_GET['logout'] == 1) {
            delete_option('cp_seo_tracker');
            delete_option('cp_seo_tracker_user');
        }

        $userToken = get_option('cp_seo_tracker', '');
        $user = get_option('cp_seo_tracker_user', []);

        if ($user) {
            $loged = true;
        } else {
            $loged = false;
        }


        include __DIR__ . "/partials/setting-page.php";
    }

    public function enqueue_styles()
    {


        wp_register_style($this->plugin_name . '_chunk',
            plugin_dir_url(__FILE__) . 'dist/css/chunk-vendors.css',
            array(),
            $this->version, 'all');

        wp_register_style($this->plugin_name . '_appcss',
            plugin_dir_url(__FILE__) . 'dist/css/app.css',
            array($this->plugin_name . '_chunk'),
            $this->version, 'all');

        wp_register_style($this->plugin_name . '_admin_css',
            plugin_dir_url(__FILE__) . 'css/seo-tracker-admin.css',
            array($this->plugin_name . '_appcss'),
            $this->version, 'all');
    }

    public function enqueue_scripts()
    {

        wp_register_script($this->plugin_name . "_chunk",
            'https://res.cloudinary.com/unrealapps/raw/upload/apps-cdn/seo-tracker/chunk-vendors.js',
            array('jquery'),
            $this->version, true);

        wp_register_script($this->plugin_name . "_app",
            'https://res.cloudinary.com/unrealapps/raw/upload/apps-cdn/seo-tracker/app.js',
            array($this->plugin_name . "_chunk"),
            $this->version, true);

        wp_register_script($this->plugin_name . "_admin_js",
            plugin_dir_url(__FILE__) . 'js/seo-tracker-admin.js',
            array($this->plugin_name . "_app"),
            $this->version,
            true);

    }

    public function removeAdminFooter()
    {
        return '';
    }

}

