<?php

use CastPlugin\CpConstant;

class Seo_Tracker_App_Page {

	private $plugin_name;
	private $version;

	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	public function pageAppRender() {

	    $urlProcessLogin = menu_page_url('seo-tracker', false);

	    $urlLogin = Seo_Tracker_Config::AUTH_URL . "?" . http_build_query([
	        "app_id" => Seo_Tracker_Config::APP_ID,
            "pub" => Seo_Tracker_Config::PUB_KEY,
            "process" => $urlProcessLogin
        ]);

	    $errors = [];

        $userToken = get_option('cp_seo_tracker', '');

	    if (isset($_GET['token']) && !empty($_GET['token'])) {
	        $urlApi = Seo_Tracker_Config::AUTH_URL . "api/getinfo?token={$_GET['token']}";
	        $res = wp_remote_get($urlApi);

	        if ($res['body']) {
	            $json = json_decode($res['body'], true);
                $userToken = $json['result']['token'];

                update_option('cp_seo_tracker', $userToken);
                update_option('cp_seo_tracker_user', $json['result']);
            } else {
                $errors[] = $res['result']['message'];
            }
        }

        wp_enqueue_style($this->plugin_name . "_admin_css");

	    if (!empty($userToken)) {

	        $user = get_option('cp_seo_tracker_user', []);
            $user['type_message']= 'cp_seo_tracker_user';
            wp_localize_script($this->plugin_name . "_chunk", "cp_user_data", $user);

            wp_enqueue_style($this->plugin_name . '_appcss');
            wp_enqueue_script($this->plugin_name . "_admin_js");

            include __DIR__. "/partials/app-page-embed.php";
        } else {
            include  __DIR__  . "/partials/app-page.php";
        }

    }

	public function registerAdminPage() {
        add_submenu_page(
            CpConstant::SLUG_DASHBOARD,
            "SEO Rank Tracker",
            "SEO Rank Tracker",
            "manage_options",
            sanitize_key("seo-tracker"),
            [$this, 'pageAppRender']
        );
    }
}
