<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              #
 * @since             1.0.0
 * @package           Seo_Tracker
 *
 * @wordpress-plugin
 * Plugin Name:       SEO Rank Tracker
 * Plugin URI:        https://codecanyon.net/item/keyword-seo-rank-tracker-wordpress-serp-rank-tracker/22646513
 * Description:       Track your SEO results with keywords that on Google & other search engine
 * Version:           2.1.0
 * Author:            Cat's Plugins
 * Author URI:        https://catsplugins.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       seo-tracker
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
use CastPlugin\CpCore;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'SEO_TRACKER_VERSION', '2.1.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-seo-tracker-activator.php
 */
function activate_seo_tracker() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-seo-tracker-activator.php';
	Seo_Tracker_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-seo-tracker-deactivator.php
 */
function deactivate_seo_tracker() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-seo-tracker-deactivator.php';
	Seo_Tracker_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_seo_tracker' );
register_deactivation_hook( __FILE__, 'deactivate_seo_tracker' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-seo-tracker.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
require_once __DIR__ . "/vendor/autoload.php";


function run_seo_tracker() {
    $cpCoreDemo = new CpCore('seo_tracker', [
        'plugin_path' => __DIR__
    ]);


    $plugin = new Seo_Tracker();
	$plugin->run();
}

run_seo_tracker();




