<div class="wrap wrap-catsplugin">
    <div id="cpApp">
        <div>
            <a-tabs>
                <a-tab-pane v-for="tab in tabs" :tab="tab.name" :key="tab.name">

                    <div class="cpPlugin" v-if="typeof tab.plugins == 'object' && tab.plugins.length > 0">
                        <a-row :gutter="16">
                            <div class="item" v-for="item in tab.plugins">
                                <a-col class="gutter-row" :span="8">
                                    <a-card hoverable style="">
                                        <img
                                                :src="item.image"
                                                slot="cover"
                                        />
                                        <a-card-meta
                                                :title="item.name"
                                                :description="item.desc">
                                        </a-card-meta>

                                        <br>


                                        <template class="ant-card-actions" slot="actions">
                                            <a-button size="small" :href="item.url_setting" v-if="item.active == 1" type="primary">Setting</a-button>
                                            <a-button size="small" :href="item.active_url" v-if="item.install == 1 && item.active != 1" type="dashed">Active</a-button>
                                            <a-button size="small" :href="item.url" v-if="item.active != 1 && !item.install" type="danger">Buy now</a-button>
                                        </template>

                                    </a-card>
                                </a-col>
                            </div>
                        </a-row>
                    </div>


                    <div class="cpPlugin" v-if="typeof tab.articles == 'object' && tab.articles.length > 0">
                        <a-row :gutter="16">
                            <div class="item" v-for="article in tab.articles">
                                <a-col class="gutter-row" :span="8">
                                    <a-card hoverable style="width: 300px">
                                        <img
                                                :src="article.image"
                                                slot="cover"
                                        />
                                        <a-card-meta
                                                :title="article.name"
                                                :description="article.desc">
                                        </a-card-meta>

                                        <template class="ant-card-actions" slot="actions">
                                            <a-button  type="link">Readmore</a-button>
                                        </template>

                                    </a-card>
                                </a-col>
                            </div>
                        </a-row>
                    </div>

                </a-tab-pane>
            </a-tabs>
        </div>
    </div>
</div>