<?php

if ( ! defined( 'ABSPATH' ) ) exit;  

class WOOCOMMERCE_CATALOG_MODE_SETTINGS extends MOTIF_WOOCOMMERCE_CATALOG_MODE {
    
    public function __construct() {

        add_action( 'wp_loaded', array( $this, 'mwcm_settings_scripts_loading' ) );

        add_action( 'admin_menu', array( $this, 'mwcm_settings_page' ), 9999999999 );

    }

    public function get_terms( $args ) {
        if ( ! is_array( $args ) ) {
            $_taxonomy = $args;
            $args = array(
                'taxonomy'   => $_taxonomy,
                'orderby'    => 'name',
                'hide_empty' => false,
            );
        }
        global $wp_version;
        
        if ( version_compare( $wp_version, '4.5.0', '>=' ) ) {
            $mwcm_terms = get_terms( $args );
        } else {
            $_taxonomy = $args['taxonomy'];
            unset( $args['taxonomy'] );
            $mwcm_terms = get_terms( $_taxonomy, $args );
        }
        
        $mwcm_terms_options = array();
        if ( ! empty( $mwcm_terms ) && ! is_wp_error( $mwcm_terms ) ){
            foreach ( $mwcm_terms as $mwcm_term ) {
                $mwcm_terms_options[ $mwcm_term->term_id ] = $mwcm_term->name;
            }
        }
        return $mwcm_terms_options;
    }

    public function mwcm_settings_page() {

        add_menu_page( 
        esc_html__( 'Motif Catalog Mode', 'motif-woocommerce-catalog-mode' ),
            esc_html__('Motif Catalog Mode', 'motif-woocommerce-catalog-mode'),
            'manage_options',
            'mwcm-settings',
            array($this,'callback_mwcm_page'),
            mwcm_url.'assets/images/motif-menu-cion.png' ,
            6
        ); 

    }

    public function callback_mwcm_page() {

        $settings_mwcm = get_option('mwcm_settings_array'); ?>

        <div id="motif-tabs">

            <div class="motif-tabs-ulli">
                <div class="motif-logo-ui">
                    <div class="motif_logo">
                      <img src="<?php echo esc_url(mwcm_url).'assets/images/motif-logo.png'; ?>" />
                    </div>
                </div>

                <ul class="motif_tab_ul">
                    <li>
                        <a href="#general_settings_wrbp">
                            <span class="dashicons dashicons-performance"></span>
                            <?php esc_html_e('General Settings', 'motif-woocommerce-catalog-mode'); ?></a>
                    </li>
                    <li>
                        <a href="#inquiry_form_wrbp">
                            <span class="dashicons dashicons-feedback"></span>
                            <?php esc_html_e('Inquiry Form', 'motif-woocommerce-catalog-mode'); ?></a>
                    </li>
                    <li>
                        <a href="#custom_button_wrbp">
                            <span class="dashicons dashicons-buddicons-forums"></span>
                            <?php esc_html_e('Custom Button', 'motif-woocommerce-catalog-mode'); ?>
                        </a>
                    </li>
                    <li>
                        <a href="#disable_button_wrbp">
                            <span class="dashicons dashicons-buddicons-forums"></span>
                            <?php esc_html_e('Review Tab', 'motif-woocommerce-catalog-mode'); ?>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="motif-tabs-content">

                <div class="motif-setting-header">
                    <h2><?php esc_html_e('Motif WooCommerce Catalog Mode', 'motif-woocommerce-catalog-mode'); ?></h2>
                    <span class="motif_loading">
                        <img src="<?php echo esc_url(mwcm_url).'assets/images/loading.gif'; ?>">
                    </span>
                    <span class="motif_style_wrap">
                        <a href="javascript:void(0);" class="motif_button_setting motif_submit"><?php esc_html_e('Save all changes', 'motif-woocommerce-catalog-mode'); ?></a>
                    </span>
                </div>

                <div class="motif_setting_optContainer">
                    
                    <form class="wordpress-ajax-form">

                        <div class="motif_option_main">

                            <!-- general settings options-->
                            <div class="motif_subpage_container" id="general_settings_wrbp">

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Enable Motif WooCommerce Catalog Mode', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Check this if you want plugin can work', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <p class="mwcm_func_enable">
                                                    <input <?php echo checked( $settings_mwcm['mwcm_func_enable'], 'yes'); ?> type="checkbox" id="mwcm_func_enable" name="mwcm_func_enable"><label for="mwcm_func_enable"></label>
                                                </p>    
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Hide Both "Price & Button" ', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Check this if you want to hide both add to cart and price in shop & detial page', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <p class="mwcm_hide_both_pri_atc">
                                                    <input <?php echo checked( $settings_mwcm['mwcm_hide_both_pri_atc'], 'yes'); ?> type="checkbox" id="mwcm_hide_both_pri_atc" name="mwcm_hide_both_pri_atc"><label for="mwcm_hide_both_pri_atc"></label>
                                                </p>    
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row" >
                                    <h4><?php esc_html_e('Exclude Products', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Exclude Product or whole category which you want not to hide price and add to cart button', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <select class="motif_select" id="mwcm_select_productexclude" name="mwcm_select_productexclude">
                                                    <option value="none">
                                                       <?php echo esc_html_e('None', ''); ?>        
                                                    </option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_select_productexclude'], 'bypro' ); ?> value="bypro">
                                                       <?php echo esc_html_e('By Product', ''); ?>        
                                                    </option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_select_productexclude'], 'bycat' ); ?> value="bycat">
                                                       <?php echo esc_html_e('By Category', ''); ?>        
                                                    </option>
                                                </select> 
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                               <?php $args = array(
                                    'post_type' => array( 'product', 'product_variation' ),
                                    'post_status' => 'publish',
                                    'ignore_sticky_posts' => 1,
                                    'posts_per_page' => -1,
                                    'orderby' => 'title',
                                    'order' => 'ASC',
                                );
                                $mwcm_products = get_posts( $args );

                                // get saved products
                                if(!empty($settings_mwcm['mwcm_product_exclude'])) {
                                    $saved_items = $settings_mwcm['mwcm_product_exclude'];
                                } else {
                                    $saved_items = array();
                                } 

                                // get saved category
                                if(!empty($settings_mwcm['mwcm_category_exclude'])) {
                                    $saved_category = $settings_mwcm['mwcm_category_exclude'];
                                } else {
                                    $saved_category = array();
                                } ?>

                                <div class="motif_setting_row" id="exclude_product">
                                    <h4><?php esc_html_e('Exclude Products', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Select Products to Exclude', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <?php if ($mwcm_products) { ?>
                                                <select multiple="" class="form-control" id="mwcm_product_exclude" name="mwcm_product_exclude[]">
                                                    <?php foreach ( $mwcm_products as $product ) { ?> 
                                                        <?php if(is_array($saved_items)){ ?>
                                                            <option value="<?php echo esc_attr($product->ID); ?>" <?php if(in_array($product->ID,$saved_items)) {echo 'selected'; }  ?>>
                                                                <?php echo esc_attr($product->post_title); ?>        
                                                            </option>
                                                        <?php } else { ?>
                                                        <option value="<?php echo esc_attr($product->ID); ?>" <?php echo selected($product->ID,$saved_items); ?>>
                                                            <?php echo esc_attr($product->post_title); ?>
                                                        </option>
                                                    <?php } } ?>
                                                </select>
                                                <?php } else { echo esc_html__('Empty Product..! Add Some.', 'motif-woocommerce-qty-range-pricing'); } ?>
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row" id="exclude_category">
                                    <h4><?php esc_html_e('Select Category', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Select Categories to Exclude', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <select multiple name="mwcm_category_exclude[]" id="mwcm_category_exclude">
                                                       <?php foreach ($this->get_terms( 'product_cat' ) as $key => $value): ?>
                                                            <option value="<?php echo esc_attr($key); ?>" <?php if(in_array($key,$saved_category)) {echo 'selected'; }  ?>>
                                                                <?php echo esc_attr($value); ?>
                                                            </option>
                                                       <?php endforeach ?>
                                                   </select>  
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Price Text', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Write some phrase, text which replace the price with this text', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <input type="text" value="<?php echo esc_attr($settings_mwcm['mwcm_rep_price']); ?>" name="mwcm_rep_price">   
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Hide By Users', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Write some phrase, text which replace the price with this text', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <select class="motif_select" id="mwcm_hide_by_user" name="mwcm_hide_by_user">
                                                    <option <?php echo selected( $settings_mwcm['mwcm_hide_by_user'], 'all' ); ?> value="all">
                                                        <?php esc_html_e('All Users', 'motif-woocommerce-catalog-mode'); ?>        
                                                    </option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_hide_by_user'], 'unregisterd' ); ?> value="unregisterd">
                                                        <?php esc_html_e('Unregistered User Only', 'motif-woocommerce-catalog-mode'); ?>
                                                    </option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_hide_by_user'], 'bycountry' ); ?> value="bycountry">
                                                        <?php esc_html_e('Hide By Country', 'motif-woocommerce-catalog-mode'); ?>        
                                                    </option>
                                                </select> 
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <?php global $wp_roles; 

                                if(!empty($settings_mwcm['mwcm_select_rolesexclude'])) {
                                    $savedRole = $settings_mwcm['mwcm_select_rolesexclude'];
                                } else {
                                    $savedRole = array();
                                } 
                                ?>
                                <div class="motif_setting_row" >
                                    <h4><?php esc_html_e('Exclude User Role', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Exclude UserRole which you want not to hide price and add to cart button', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <select multiple class="motif_select" id="mwcm_select_rolesexclude" name="mwcm_select_rolesexclude[]">
                                                    <option value="none">
                                                       <?php echo esc_html_e('None', ''); ?>        
                                                    </option>
                                                    <?php foreach ( $wp_roles->roles as $key=>$value ): ?>
                                                        <option value="<?php echo $key; ?>" <?php if(in_array($key,$savedRole)) {echo 'selected'; }  ?>><?php echo $value['name']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>

                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <?php

                                    if(!empty($settings_mwcm['mwcm_select_country'])) {
                                        $saved_country = $settings_mwcm['mwcm_select_country'];
                                    } else {
                                        $saved_country = array();
                                    } 
                                ?>

                                <div class="motif_setting_row" id="mwcm_select_country">
                                    <h4><?php esc_html_e('Select Countries', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Select countries to hide price and add to cart button based on select countries', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <select multiple="true" class="motif_select mwcm_select_country" name="mwcm_select_country[]">
                                                <?php   $countries_obj   = new WC_Countries();
                                                        $countries   = $countries_obj->__get('countries');
                                                        foreach ($countries as $key => $value) { ?>
                                                            <option <?php if(in_array($key, $saved_country)) { echo "selected"; }?>  value="<?php echo esc_attr($key); ?>">
                                                                <?php echo esc_attr($value); ?>        
                                                            </option>
                                                <?php   } ?>
                                                </select> 
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                            </div>
                            <!-- general settings options-->

                            <!-- inquiry form options-->
                            <div class="motif_subpage_container" id="inquiry_form_wrbp">
                                
                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Enable Form Display', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('check this if you want to dispaly contact form 7 on single product page', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <p class="mwcm_cf7_enable">
                                                    <input type="checkbox" <?php echo checked( $settings_mwcm['mwcm_cf7_enable'], 'yes'); ?> id="mwcm_cf7_enable" name="mwcm_cf7_enable"><label for="mwcm_cf7_enable"></label>
                                                </p>    
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Select Short Code', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Select Short Code to disaly', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <select class="motif_select" name="mwcm_select_shortcode" id="mwcm_select_shortcode"> 
                                                    <option value="none">
                                                        <?php esc_html_e('None', 'motif-woocommerce-catalog-mode'); ?>        
                                                    </option>
                                                    <?php   $cF7s = get_posts(array(
                                                                'post_type'     => 'wpcf7_contact_form',
                                                                'numberposts'   => -1
                                                            ));
                                                    foreach ( $cF7s as $forms ) { ?>
                                                        <option <?php echo selected( $settings_mwcm['mwcm_select_shortcode'], $forms->ID ); ?> value="<?php echo esc_attr($forms->ID); ?>"><?php echo esc_attr($forms->post_title); ?></option>
                                                    <?php } ?>
                                                </select>
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Form Position', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Select the postion of form to display in single product page', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <select class="motif_select" name="mwcm_select_formplace" id="mwcm_select_formplace"> 
                                                    <option <?php echo selected( $settings_mwcm['mwcm_select_formplace'], 'tab' ); ?> value="tab"><?php esc_html_e('Product Tab', 'motif-woocommerce-catalog-mode'); ?></option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_select_formplace'], '15' ); ?> value="15"><?php esc_html_e('After Product Price', 'motif-woocommerce-catalog-mode'); ?></option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_select_formplace'], '25' ); ?> value="25"><?php esc_html_e('After short Description', 'motif-woocommerce-catalog-mode'); ?></option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_select_formplace'], '35' ); ?> value="35"><?php esc_html_e('After AddToCart Button', 'motif-woocommerce-catalog-mode'); ?></option>
                                                </select>
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Title Of Tab', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Product tab tile where you can add a form in single product page', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <input type="text" value="<?php echo esc_attr($settings_mwcm['mwcm_tab_titlef7']); ?>" name="mwcm_tab_titlef7">   
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Product Permalink', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Send Product permalink to email with contact form 7 to know which specific product is', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <p class="mwcm_cf7_proper">
                                                    <input type="checkbox" <?php echo checked( $settings_mwcm['mwcm_cf7_proper'], 'yes'); ?> id="mwcm_cf7_proper" name="mwcm_cf7_proper"><label for="mwcm_cf7_proper"></label>
                                                </p>    
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>   

                            </div>
                            <!-- inquiry form options-->

                            <!-- custom button options -->
                            <div class="motif_subpage_container" id="custom_button_wrbp">

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Custom Button Shop Page', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Check this if you want to add custom button in shop.', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <p class="mwcm_customshop_enable">
                                                    <input type="checkbox" <?php echo checked( $settings_mwcm['mwcm_customshop_enable'], 'yes'); ?> id="mwcm_customshop_enable" name="mwcm_customshop_enable"><label for="mwcm_customshop_enable"></label>
                                                </p>    
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Custom Button Single Page', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Check this if you want to add custom button in single pages.', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <p class="mwcm_customsingle_enable">
                                                    <input type="checkbox" <?php echo checked( $settings_mwcm['mwcm_customsingle_enable'], 'yes'); ?> id="mwcm_customsingle_enable" name="mwcm_customsingle_enable"><label for="mwcm_customsingle_enable"></label>
                                                </p>    
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Button Text Color', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Custom button text color', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <input type="text" name="mwcm_text_color" value="<?php echo esc_attr($settings_mwcm['mwcm_text_color']); ?>" class="mwcm_text_color" />
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Button Background Color', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Custom button Background color', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <input type="text" name="mwcm_backbtn_color" value="<?php echo esc_attr($settings_mwcm['mwcm_backbtn_color']); ?>" class="mwcm_backbtn_color" />
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Button Hover Color', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Custom button text Hover color', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <input type="text" name="mwcm_hovbtn_color" value="<?php echo esc_attr($settings_mwcm['mwcm_hovbtn_color']); ?>" class="mwcm_hovbtn_color" />
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Button Hover Background', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Custom button background Hover color', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <input type="text" name="mwcm_bhovbtn_color" value="<?php echo esc_attr($settings_mwcm['mwcm_bhovbtn_color']); ?>" class="mwcm_bhovbtn_color" />
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Button Icon', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Set Icon to button or not', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <select class="motif_select" name="mwcm_btnicon_type" id="mwcm_btnicon_type"> 
                                                    <option <?php echo selected( $settings_mwcm['mwcm_btnicon_type'], 'none' ); ?> value="none"><?php esc_html_e('None', 'motif-woocommerce-catalog-mode'); ?></option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_btnicon_type'], 'theme' ); ?> value="theme"><?php esc_html_e('Theme Icons', 'motif-woocommerce-catalog-mode'); ?></option>
                                                </select>
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row" id="icon_container_mwcm">
                                    <h4><?php esc_html_e('Select Icon', ''); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Select Icon for your custom buttons', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <div class="mwcm_iconpicker">
                                                    <?php require_once(mwcm_dir.'includes/mwcm-functions.php'); ?>
                                                    <input type="hidden" id="mwcm_btn_icon" name="mwcm_btn_icon" value="<?php echo $settings_mwcm['mwcm_btn_icon']; ?>"/>
                                                </div>
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Button Link Type', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Set a custom button link type', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <select class="motif_select" name="mwcm_btnlink_type" id="mwcm_btnlink_type"> 
                                                    <option <?php echo selected( $settings_mwcm['mwcm_btnlink_type'], 'url' ); ?> value="url"><?php esc_html_e('URL Link', 'motif-woocommerce-catalog-mode'); ?></option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_btnlink_type'], 'email' ); ?> value="email"><?php esc_html_e('Email Address', 'motif-woocommerce-catalog-mode'); ?></option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_btnlink_type'], 'phone' ); ?> value="phone"><?php esc_html_e('Phone Number', 'motif-woocommerce-catalog-mode'); ?></option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_btnlink_type'], 'skype' ); ?> value="skype"><?php esc_html_e('Skype Contact', 'motif-woocommerce-catalog-mode'); ?></option>
                                                </select>
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('URL Link', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Set Button Like data', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <input type="text" name="mwcm_btnurl_link" value="<?php echo esc_attr($settings_mwcm['mwcm_btnurl_link']); ?>" class="mwcm_btnurl_link" />
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Button Text', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Set the custom button text', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <input type="text" name="mwcm_btntext_link" value="<?php echo esc_attr($settings_mwcm['mwcm_btntext_link']); ?>" class="mwcm_btntext_link" />
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Link Open', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Check if you want to open custom button link in new tab for url only', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <p class="mwcm_newtab_link">
                                                    <input type="checkbox" <?php echo checked( $settings_mwcm['mwcm_newtab_link'], 'yes'); ?> id="mwcm_newtab_link" name="mwcm_newtab_link"><label for="mwcm_newtab_link"></label>
                                                </p>    
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                            </div>
                            <!-- custom button options -->

                            <!-- review and disable shop -->
                            <div class="motif_subpage_container" id="disable_button_wrbp">
                                
                                <div class="motif_setting_row">
                                    <h4><?php esc_html_e('Product Reviews', 'motif-woocommerce-catalog-mode'); ?></h4>
                                    <div class="motif_setting_control">
                                        <div class="motif_control_description">
                                            <p>
                                                <?php esc_html_e('Disable Review tab on single product page for users', 'motif-woocommerce-catalog-mode'); ?>
                                            </p>
                                        </div>
                                        <div class="motif_control_field">
                                            <span class="moif_style_wrap">
                                                <select class="motif_select" name="mwcm_pro_review" id="mwcm_pro_review"> 
                                                    <option <?php echo selected( $settings_mwcm['mwcm_pro_review'], 'enabled' ); ?> value="enabled"><?php esc_html_e('Enabled', 'motif-woocommerce-catalog-mode'); ?></option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_pro_review'], 'diableall' ); ?> value="diableall"><?php esc_html_e('Disabled For All Users', 'motif-woocommerce-catalog-mode'); ?></option>
                                                    <option <?php echo selected( $settings_mwcm['mwcm_pro_review'], 'foregister' ); ?> value="foregister"><?php esc_html_e('Enable for Registered User', 'motif-woocommerce-catalog-mode'); ?></option>
                                                </select>
                                            </span>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>

                            </div>
                            <!-- review and disable shop -->

                        </div>

                    </form>

                </div>

            </div>

        </div>
        
    <?php }

    public function mwcm_settings_scripts_loading() {

        wp_enqueue_script('jquery');

        wp_enqueue_script('jquery-ui-tabs');

        wp_enqueue_script( 'select2-full', plugins_url( '../assets/js/select2.full.min.js', __FILE__ ), false );

        wp_enqueue_script( 'select2', plugins_url( '../assets/js/select2.min.js', __FILE__ ), false );
        
        wp_enqueue_script( 'mwcm-settings', plugins_url( '../assets/js/setting.js', __FILE__ ), false );

        wp_enqueue_style('select2', plugins_url( '../assets/css/select2.min.css', __FILE__ ), false );

        wp_enqueue_style('fontawesome', plugins_url( '../assets/css/font-awesome.min.css', __FILE__ ), false );

        wp_localize_script( 'mwcm-settings', 'mwcm_data_vars', array(
                'mwcm_nonce' => wp_create_nonce('mwcm_nonce'),
                'ajax_url' => admin_url('admin-ajax.php')
            )
        );
    }

} new WOOCOMMERCE_CATALOG_MODE_SETTINGS();