<?php

if ( ! defined( 'ABSPATH' ) ) exit;  

class WOOCOMMERCE_CATALOG_MODE_FRONT extends MOTIF_WOOCOMMERCE_CATALOG_MODE {
    
    public function __construct() {

        add_action( 'wp', array( $this, 'mwcm_front_scripts_loading' ) );

        // get settings 
        $mwcmSettings = get_option('mwcm_settings_array');

        if ( $mwcmSettings['mwcm_func_enable'] == 'yes'  ) {
        	

			if (! is_admin() ||  defined( 'DOING_AJAX' ) && DOING_AJAX &&  $mwcmSettings['mwcm_hide_by_user'] == "all") {

				// exclude user role
				include_once(ABSPATH . 'wp-includes/pluggable.php');
				$user = wp_get_current_user();
				if ( in_array( $user->roles[0], (array)$mwcmSettings['mwcm_select_rolesexclude']  ) ) {
				   // skip
				} else {
					// add to cart
					add_action('after_setup_theme', array($this,'addtoCart_button_hide'), 53);
					// hide price
					add_filter( 'woocommerce_get_price_html', array( $this, 'show_product_price' ), 10, 2 );
					add_filter( 'woocommerce_get_variation_price_html', array( $this, 'show_product_price' ), 10, 2 );
				}
				
			} else if(! is_admin() ||  defined( 'DOING_AJAX' ) && DOING_AJAX  && $mwcmSettings['mwcm_hide_by_user'] == "unregisterd") {
				if (!is_user_logged_in()) {

					// add to cart
					add_action('after_setup_theme', array($this,'addtoCart_button_hide'), 53);
					// hide price
					add_filter( 'woocommerce_get_price_html', array( $this, 'show_product_price' ), 10, 2 );
					add_filter( 'woocommerce_get_variation_price_html', array( $this, 'show_product_price' ), 10, 2 );
				}
			
			} else if(! is_admin() ||  defined( 'DOING_AJAX' ) && DOING_AJAX  && $mwcmSettings['mwcm_hide_by_user'] == "bycountry") {
				// to-do by country
			}

			// contact form 7 function 
			if($mwcmSettings['mwcm_func_enable'] == "yes" && $mwcmSettings['mwcm_cf7_enable'] == "yes" && $mwcmSettings['mwcm_select_formplace'] == 'tab') {
	        	add_filter( 'woocommerce_product_tabs', array($this, 'mwcm_product_tabs') );
	    	} else if($mwcmSettings['mwcm_func_enable'] == "yes" && $mwcmSettings['mwcm_cf7_enable'] == "yes") {
	    		if($mwcmSettings['mwcm_select_formplace'] != 'tab') {
	    			$placePriority = $mwcmSettings['mwcm_select_formplace'];
	        		$hooks = apply_filters( 'mwcm_hooks_single_page_form', 'woocommerce_single_product_summary' );
					$placePriority = apply_filters( 'mwcm_hooks_single_page_form_priority', $placePriority );
					add_action( $hooks, array( $this, 'mwcm_form_shortcode' ), $placePriority );
	    		}
	    	}

	    		include_once(ABSPATH . 'wp-includes/pluggable.php');
				$user = wp_get_current_user();
				if ( in_array( $user->roles[0], (array)$mwcmSettings['mwcm_select_rolesexclude']  ) ) {
				   // skip
				} else {
					// add custom button on shop page
			    	add_action( 'woocommerce_after_shop_loop_item', array( $this, 'mwcm_shop_button' ), 20 );
			    	add_action( 'woocommerce_single_product_summary', array( $this, 'mwcm_single_button' ), 20 );
				}
	    	
	    	// disable reviews
			add_filter( 'woocommerce_product_tabs', array( $this, 'mwcm_remove_reviews_tab' ), 98 );	
		}
		add_filter( 'wpcf7_mail_components', array( $this, 'mwcm_mail_components' ), 10, 2 );
    }

    // disable tab review
    public function mwcm_remove_reviews_tab($tabs) {
       	
       	$mwcmSettings = get_option('mwcm_settings_array');

       	if($mwcmSettings['mwcm_pro_review'] == "diableall") {
			unset( $tabs['reviews'] );
		}

		if ( is_user_logged_in() && $mwcmSettings['mwcm_pro_review'] == "foregister") {
			unset( $tabs['reviews'] );
		}
		return $tabs;
    }

    // custom button for single product page
    public function mwcm_single_button() {

    	global $post;

		if ( ! isset( $post ) ) {
			return;
		}

    	$CurrentId = $post->ID;
        // add check for exclude product
        $mwcmSettings = get_option('mwcm_settings_array');

        if($mwcmSettings['mwcm_select_productexclude'] == "bypro") {
        	
        	// get all products of exlude
        	if(!empty($mwcmSettings['mwcm_product_exclude'])) {
        		$excludeProductIds = $mwcmSettings['mwcm_product_exclude'];
        	}else {
        		$excludeProductIds = array();
        	}

        	if(!in_array($CurrentId, $excludeProductIds)) {

				if ( $mwcmSettings['mwcm_customshop_enable'] == 'yes' ) { 

					// set custom button as theme
					$setIcon = (($mwcmSettings['mwcm_btnicon_type'] == 'theme' ) ? 'yes' : '' );
					if($setIcon == "yes") {
						$icon = $mwcmSettings['mwcm_btn_icon'];

						$iconBtn = "<i class='".$icon."' data-name='".$icon."'></i>";
					} else {
						$iconBtn ="";
					}

					// set the link type
					if(!empty($mwcmSettings['mwcm_btnlink_type'])) {
						$linktype = $mwcmSettings['mwcm_btnlink_type'];
					}else {
						$linktype = "";
					}

					// get url link
					if(!empty($mwcmSettings['mwcm_btnurl_link'])) {
						$urlLink = $mwcmSettings['mwcm_btnurl_link'];
					}else {
						$urlLink = "";
					}

					// enable new tab open link
					$newtab = (($mwcmSettings['mwcm_newtab_link'] == 'yes' ) ? ' target="_blank" ' : '' );

					// button text 
					if(!empty($mwcmSettings['mwcm_btntext_link'])) {
						$btnText = $mwcmSettings['mwcm_btntext_link'];
					}else {
						$btnText = esc_html__('View', 'motif-woocommerce-catalog-mode');
					}

					switch ( $linktype ) :
						case 'url':
							?>
		                    <div class="mwcm_button_wrap">
								<a <?php echo esc_attr($newtab); ?> href="<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>			
								</a>
							</div>
							<?php break;
						case 'email':
							?>
		                   	<div class="mwcm_button_wrap">
								<a href="mailto:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>			
								</a>
							</div>
							<?php break;
						case 'phone':
							?>
			               	<div class="mwcm_button_wrap">
								<a href="tel:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>		
								</a>
							</div>
							<?php break;
						case 'skype':
							?>
			                <div class="mwcm_button_wrap">
								<a href="skype:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>		
								</a>
							</div>
							<?php break;
					endswitch; ?>
			<?php }
        	}

		} else if($mwcmSettings['mwcm_select_productexclude'] == "bycat") {

			// get all category of exlude
        	if(!empty($mwcmSettings['mwcm_category_exclude'])) {
        		$excludecatIds = $mwcmSettings['mwcm_category_exclude'];
        	}else {
        		$excludecatIds = array();
        	}

        	// get all categories of current product
        	$terms = get_the_terms( $CurrentId, 'product_cat' );
        	$product_cat_id = array();
        	foreach ($terms as $term) {
			    $product_cat_id[] = $term->term_id;
			}

			// array difference 
			$arr3 = array_diff($excludecatIds, $product_cat_id);

			$existCategory = count($arr3);

			if($existCategory == 0 ) {

				if ( $mwcmSettings['mwcm_customshop_enable'] == 'yes' ) { 

				// set custom button as theme
				$setIcon = (($mwcmSettings['mwcm_btnicon_type'] == 'theme' ) ? 'yes' : '' );
				if($setIcon == "yes") {
					$icon = $mwcmSettings['mwcm_btn_icon'];

					$iconBtn = "<i class='".$icon."' data-name='".$icon."'></i>";
				} else {
					$iconBtn ="";
				}

				// set the link type
				if(!empty($mwcmSettings['mwcm_btnlink_type'])) {
					$linktype = $mwcmSettings['mwcm_btnlink_type'];
				}else {
					$linktype = "";
				}

				// get url link
				if(!empty($mwcmSettings['mwcm_btnurl_link'])) {
					$urlLink = $mwcmSettings['mwcm_btnurl_link'];
				}else {
					$urlLink = "";
				}

				// enable new tab open link
				$newtab = (($mwcmSettings['mwcm_newtab_link'] == 'yes' ) ? ' target="_blank" ' : '' );

				// button text 
				if(!empty($mwcmSettings['mwcm_btntext_link'])) {
					$btnText = $mwcmSettings['mwcm_btntext_link'];
				}else {
					$btnText = esc_html__('View', 'motif-woocommerce-catalog-mode');
				}

				switch ( $linktype ) :
					case 'url':
						?>
	                    <div class="mwcm_button_wrap">
							<a <?php echo esc_attr($newtab); ?> href="<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>			
							</a>
						</div>
						<?php break;
					case 'email':
						?>
	                   	<div class="mwcm_button_wrap">
							<a href="mailto:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>			
							</a>
						</div>
						<?php break;
					case 'phone':
						?>
		               	<div class="mwcm_button_wrap">
							<a href="tel:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>		
							</a>
						</div>
						<?php break;
					case 'skype':
						?>
		                <div class="mwcm_button_wrap">
							<a href="skype:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>		
							</a>
						</div>
						<?php break;
				endswitch; ?>
			<?php }
				
			}

		} else {

			if ( $mwcmSettings['mwcm_customshop_enable'] == 'yes' ) { 

					// set custom button as theme
					$setIcon = (($mwcmSettings['mwcm_btnicon_type'] == 'theme' ) ? 'yes' : '' );
					if($setIcon == "yes") {
						$icon = $mwcmSettings['mwcm_btn_icon'];

						$iconBtn = "<i class='".$icon."' data-name='".$icon."'></i>";
					} else {
						$iconBtn ="";
					}

					// set the link type
					if(!empty($mwcmSettings['mwcm_btnlink_type'])) {
						$linktype = $mwcmSettings['mwcm_btnlink_type'];
					}else {
						$linktype = "";
					}

					// get url link
					if(!empty($mwcmSettings['mwcm_btnurl_link'])) {
						$urlLink = $mwcmSettings['mwcm_btnurl_link'];
					}else {
						$urlLink = "";
					}

					// enable new tab open link
					$newtab = (($mwcmSettings['mwcm_newtab_link'] == 'yes' ) ? ' target="_blank" ' : '' );

					// button text 
					if(!empty($mwcmSettings['mwcm_btntext_link'])) {
						$btnText = $mwcmSettings['mwcm_btntext_link'];
					}else {
						$btnText = esc_html__('View', 'motif-woocommerce-catalog-mode');
					}

					switch ( $linktype ) :
						case 'url':
							?>
		                    <div class="mwcm_button_wrap">
								<a <?php echo esc_attr($newtab); ?> href="<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>			
								</a>
							</div>
							<?php break;
						case 'email':
							?>
		                   	<div class="mwcm_button_wrap">
								<a href="mailto:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>			
								</a>
							</div>
							<?php break;
						case 'phone':
							?>
			               	<div class="mwcm_button_wrap">
								<a href="tel:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>		
								</a>
							</div>
							<?php break;
						case 'skype':
							?>
			                <div class="mwcm_button_wrap">
								<a href="skype:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>		
								</a>
							</div>
							<?php break;
					endswitch; ?>
			<?php }
		}
	}

    // custom button for shop
    public function mwcm_shop_button() {

    	global $post;

		if ( ! isset( $post ) ) {
			return;
		}

    	$CurrentId = $post->ID;
        // add check for exclude product
        $mwcmSettings = get_option('mwcm_settings_array');

        if($mwcmSettings['mwcm_select_productexclude'] == "bypro") {
        	
        	// get all products of exlude
        	if(!empty($mwcmSettings['mwcm_product_exclude'])) {
        		$excludeProductIds = $mwcmSettings['mwcm_product_exclude'];
        	}else {
        		$excludeProductIds = array();
        	}

        	if(!in_array($CurrentId, $excludeProductIds)) {

				if ( $mwcmSettings['mwcm_customshop_enable'] == 'yes' ) { 

					// set custom button as theme
					$setIcon = (($mwcmSettings['mwcm_btnicon_type'] == 'theme' ) ? 'yes' : '' );
					if($setIcon == "yes") {
						$icon = $mwcmSettings['mwcm_btn_icon'];

						$iconBtn = "<i class='".$icon."' data-name='".$icon."'></i>";
					} else {
						$iconBtn ="";
					}

					// set the link type
					if(!empty($mwcmSettings['mwcm_btnlink_type'])) {
						$linktype = $mwcmSettings['mwcm_btnlink_type'];
					}else {
						$linktype = "";
					}

					// get url link
					if(!empty($mwcmSettings['mwcm_btnurl_link'])) {
						$urlLink = $mwcmSettings['mwcm_btnurl_link'];
					}else {
						$urlLink = "";
					}

					// enable new tab open link
					$newtab = (($mwcmSettings['mwcm_newtab_link'] == 'yes' ) ? ' target="_blank" ' : '' );

					// button text 
					if(!empty($mwcmSettings['mwcm_btntext_link'])) {
						$btnText = $mwcmSettings['mwcm_btntext_link'];
					}else {
						$btnText = esc_html__('View', 'motif-woocommerce-catalog-mode');
					}

					switch ( $linktype ) :
						case 'url':
							?>
		                    <div class="mwcm_button_wrap">
								<a <?php echo esc_attr($newtab); ?> href="<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>			
								</a>
							</div>
							<?php break;
						case 'email':
							?>
		                   	<div class="mwcm_button_wrap">
								<a href="mailto:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>			
								</a>
							</div>
							<?php break;
						case 'phone':
							?>
			               	<div class="mwcm_button_wrap">
								<a href="tel:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>		
								</a>
							</div>
							<?php break;
						case 'skype':
							?>
			                <div class="mwcm_button_wrap">
								<a href="skype:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
									<?php echo $iconBtn; ?> 
									<?php echo esc_attr($btnText); ?>		
								</a>
							</div>
							<?php break;
					endswitch; ?>
				<?php }
			}

        } else if ($mwcmSettings['mwcm_select_productexclude'] == "bycat") {

        	// get all category of exlude
        	if(!empty($mwcmSettings['mwcm_category_exclude'])) {
        		$excludecatIds = $mwcmSettings['mwcm_category_exclude'];
        	}else {
        		$excludecatIds = array();
        	}

        	// get all categories of current product
        	$terms = get_the_terms( $CurrentId, 'product_cat' );
        	$product_cat_id = array();
        	foreach ($terms as $term) {
			    $product_cat_id[] = $term->term_id;
			}

			// array difference 
			$arr3 = array_diff($excludecatIds, $product_cat_id);

			$existCategory = count($arr3);

			if($existCategory == 0 ) {

				if ( $mwcmSettings['mwcm_customshop_enable'] == 'yes' ) { 

				// set custom button as theme
				$setIcon = (($mwcmSettings['mwcm_btnicon_type'] == 'theme' ) ? 'yes' : '' );
				if($setIcon == "yes") {
					$icon = $mwcmSettings['mwcm_btn_icon'];

					$iconBtn = "<i class='".$icon."' data-name='".$icon."'></i>";
				} else {
					$iconBtn ="";
				}

				// set the link type
				if(!empty($mwcmSettings['mwcm_btnlink_type'])) {
					$linktype = $mwcmSettings['mwcm_btnlink_type'];
				}else {
					$linktype = "";
				}

				// get url link
				if(!empty($mwcmSettings['mwcm_btnurl_link'])) {
					$urlLink = $mwcmSettings['mwcm_btnurl_link'];
				}else {
					$urlLink = "";
				}

				// enable new tab open link
				$newtab = (($mwcmSettings['mwcm_newtab_link'] == 'yes' ) ? ' target="_blank" ' : '' );

				// button text 
				if(!empty($mwcmSettings['mwcm_btntext_link'])) {
					$btnText = $mwcmSettings['mwcm_btntext_link'];
				}else {
					$btnText = esc_html__('View', 'motif-woocommerce-catalog-mode');
				}

				switch ( $linktype ) :
					case 'url':
						?>
	                    <div class="mwcm_button_wrap">
							<a <?php echo esc_attr($newtab); ?> href="<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>			
							</a>
						</div>
						<?php break;
					case 'email':
						?>
	                   	<div class="mwcm_button_wrap">
							<a href="mailto:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>			
							</a>
						</div>
						<?php break;
					case 'phone':
						?>
		               	<div class="mwcm_button_wrap">
							<a href="tel:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>		
							</a>
						</div>
						<?php break;
					case 'skype':
						?>
		                <div class="mwcm_button_wrap">
							<a href="skype:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>		
							</a>
						</div>
						<?php break;
				endswitch; ?>
			<?php }

			}

        } else {

			if ( $mwcmSettings['mwcm_customshop_enable'] == 'yes' ) { 

				// set custom button as theme
				$setIcon = (($mwcmSettings['mwcm_btnicon_type'] == 'theme' ) ? 'yes' : '' );
				if($setIcon == "yes") {
					$icon = $mwcmSettings['mwcm_btn_icon'];

					$iconBtn = "<i class='".$icon."' data-name='".$icon."'></i>";
				} else {
					$iconBtn ="";
				}

				// set the link type
				if(!empty($mwcmSettings['mwcm_btnlink_type'])) {
					$linktype = $mwcmSettings['mwcm_btnlink_type'];
				}else {
					$linktype = "";
				}

				// get url link
				if(!empty($mwcmSettings['mwcm_btnurl_link'])) {
					$urlLink = $mwcmSettings['mwcm_btnurl_link'];
				}else {
					$urlLink = "";
				}

				// enable new tab open link
				$newtab = (($mwcmSettings['mwcm_newtab_link'] == 'yes' ) ? ' target="_blank" ' : '' );

				// button text 
				if(!empty($mwcmSettings['mwcm_btntext_link'])) {
					$btnText = $mwcmSettings['mwcm_btntext_link'];
				}else {
					$btnText = esc_html__('View', 'motif-woocommerce-catalog-mode');
				}

				switch ( $linktype ) :
					case 'url':
						?>
	                    <div class="mwcm_button_wrap">
							<a <?php echo esc_attr($newtab); ?> href="<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>			
							</a>
						</div>
						<?php break;
					case 'email':
						?>
	                   	<div class="mwcm_button_wrap">
							<a href="mailto:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>			
							</a>
						</div>
						<?php break;
					case 'phone':
						?>
		               	<div class="mwcm_button_wrap">
							<a href="tel:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>		
							</a>
						</div>
						<?php break;
					case 'skype':
						?>
		                <div class="mwcm_button_wrap">
							<a href="skype:<?php echo esc_attr($urlLink); ?>" class="button mwcm_custom_button">
								<?php echo $iconBtn; ?> 
								<?php echo esc_attr($btnText); ?>		
							</a>
						</div>
						<?php break;
				endswitch; ?>
			<?php }
		}
    }

    // display form with shortcode
    public function mwcm_form_shortcode() {
    	
    	global $product; 

    	$mwcmSettings = get_option('mwcm_settings_array');

    		if(!empty($mwcmSettings['mwcm_tab_titlef7'])) {
    			$titleTab = $mwcmSettings['mwcm_tab_titlef7'];
    		}else {
    			$titleTab = esc_html__('Contact Form 7', 'motif-woocommerce-catalog-mode');
    		}

    	 ?>

        <div class="mwcm_single_product_form">
			<span class="mwcm-form-title">
				<?php echo apply_filters( 'mwcm_contact_form_title', $titleTab ); ?>
			</span>
        	<?php echo do_shortcode('[contact-form-7 id="'.$mwcmSettings['mwcm_select_shortcode'].'" title="Contact form 1"]'); ?>
        </div>
    <?php }

    // enable tabs if form postion is tab
    public function mwcm_product_tabs( $tabs ) {
        
        global $post;
            
        $tabs['mwcm_meta_box'] = array(
            'title'    => esc_html__( 'Inquiry Form', 'motif-woocommerce-catalog-mode' ),
            'priority' => 45,
            'callback' => array($this,'_mwcm_product_tab_content')
        );

        return $tabs;
    }

    // tab content display
    public function _mwcm_product_tab_content() {
        
        global $post;

        $mwcmSettings = get_option('mwcm_settings_array');

        if(!empty($mwcmSettings['mwcm_tab_titlef7'])) {
			$titleTab = $mwcmSettings['mwcm_tab_titlef7'];
		}else {
			$titleTab = esc_html__('Contact Form 7', 'motif-woocommerce-catalog-mode');
		}

        echo '<h2>' . esc_html__( $titleTab, 'motif-woocommerce-catalog-mode' ) . '</h2>';

        echo apply_filters( 'the_content', '[contact-form-7 id="'.$mwcmSettings['mwcm_select_shortcode'].'" title="Contact form 1"]' );
    }

    // add to cart hide hook init
    public function addtoCart_button_hide() {
      
        add_filter('woocommerce_after_shop_loop_item_title', array($this,'addtoCart_button_hide_function'));
        add_filter('woocommerce_single_product_summary', array($this,'addtoCart_button_hide_function'));
    }

    // hide product add to cart both shop and single product page
	public function addtoCart_button_hide_function() {

		global $post;

    	$CurrentId = $post->ID;
        // add check for exclude product
        $mwcmSettings = get_option('mwcm_settings_array');

        if($mwcmSettings['mwcm_select_productexclude'] == "bypro") {
        	
        	// get all products of exlude
        	if(!empty($mwcmSettings['mwcm_product_exclude'])) {
        		$excludeProductIds = $mwcmSettings['mwcm_product_exclude'];
        	}else {
        		$excludeProductIds = array();
        	}

        	if(!in_array($CurrentId, $excludeProductIds)) {

        		// if hide both
				if ( $mwcmSettings['mwcm_hide_both_pri_atc'] == 'yes' ) {

					// for shop page
					remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
		            // for single product page
		            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
				}
        	}
        } else if($mwcmSettings['mwcm_select_productexclude'] == "bycat") {

        	// get all category of exlude
        	if(!empty($mwcmSettings['mwcm_category_exclude'])) {
        		$excludecatIds = $mwcmSettings['mwcm_category_exclude'];
        	}else {
        		$excludecatIds = array();
        	}

        	// get all categories of current product
        	$terms = get_the_terms( $CurrentId, 'product_cat' );
        	$product_cat_id = array();
        	foreach ($terms as $term) {
			    $product_cat_id[] = $term->term_id;
			}

			// array difference 
			$arr3 = array_diff($excludecatIds, $product_cat_id);

			$existCategory = count($arr3);

			if($existCategory == 0 ){
				
				if ( $mwcmSettings['mwcm_hide_both_pri_atc'] == 'yes' ) {
					remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
		            // for single product page
		        	remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
		    	}
			} else {

					add_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
					add_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
				
			}
        } else {

        	if ( $mwcmSettings['mwcm_hide_both_pri_atc'] == 'yes' ) {

				// for shop page
				remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
	            // for single product page
	            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
			}
        }
	}

    public function show_product_price($price, $product) {

		global $post;

    	$CurrentId = $post->ID;
        // add check for exclude product
        $mwcmSettings = get_option('mwcm_settings_array');

        if($mwcmSettings['mwcm_select_productexclude'] == "bypro") {
        	
        	// get all products of exlude
        	if(!empty($mwcmSettings['mwcm_product_exclude'])) {
        		$excludeProductIds = $mwcmSettings['mwcm_product_exclude'];
        	}else {
        		$excludeProductIds = array();
        	}

        	if(!in_array($CurrentId, $excludeProductIds)) {

        		// if hide both
				if ( $mwcmSettings['mwcm_hide_both_pri_atc'] == 'yes' ) {

					$price = $this->mwcm_price_label( $price, $product );

					if ( current_filter() == 'woocommerce_get_price' || current_filter() == 'woocommerce_product_get_price' && ! $price ) {

						$text  = esc_html__( 'Price is hidden!', 'motif-woocommerce-catalog-mode' );
						$price = apply_filters( 'mwcm_hidden_price', $text );
					} 
		    	
		    		return $price;

				} else {
					
					return $price;
				}
        	}

        	return $price;

        } else if($mwcmSettings['mwcm_select_productexclude'] == "bycat") {

        	// get all category of exlude
        	if(!empty($mwcmSettings['mwcm_category_exclude'])) {
        		$excludecatIds = $mwcmSettings['mwcm_category_exclude'];
        	}else {
        		$excludecatIds = array();
        	}

        	// get all categories of current product
        	$terms = get_the_terms( $CurrentId, 'product_cat' );
        	$product_cat_id = array();
        	foreach ($terms as $term) {
			    $product_cat_id[] = $term->term_id;
			}

			// array difference 
			$arr3 = array_diff($excludecatIds, $product_cat_id);

			$existCategory = count($arr3);

			if($existCategory == 0 ) {
			
        		// if hide both
				if ( $mwcmSettings['mwcm_hide_both_pri_atc'] == 'yes' ) {

					$price = $this->mwcm_price_label( $price, $product );

					if ( current_filter() == 'woocommerce_get_price' || current_filter() == 'woocommerce_product_get_price' && ! $price ) {

						$text  = esc_html__( 'Price is hidden!', 'motif-woocommerce-catalog-mode' );
						$price = apply_filters( 'mwcm_hidden_price', $text );
					} 
		    	
		    		return $price;

				} else {
					
					return $price;
				}
        	}

        	return $price;

        } else {

        	// if hide both
			if ( $mwcmSettings['mwcm_hide_both_pri_atc'] == 'yes' ) {

				$price = $this->mwcm_price_label( $price, $product );

				if ( current_filter() == 'woocommerce_get_price' || current_filter() == 'woocommerce_product_get_price' && ! $price ) {

					$text  = esc_html__( 'Price is hidden!', 'motif-woocommerce-catalog-mode' );
					$price = apply_filters( 'mwcm_hidden_price', $text );
				} 
	    	
	    		return $price;

			} else {
				
				return $price;
			}
        }
    }

    // if price text return else price
	function mwcm_price_label($price, $product) {
		
		$mwcmSettings = get_option('mwcm_settings_array');

		$productID = $product->get_id();
		$priceText = $mwcmSettings['mwcm_rep_price'] ? $mwcmSettings['mwcm_rep_price'] : "";

		return ( $priceText != '' ? $priceText : '' );
	}

	// check for admin catalog mode is on
    function check_admin_user() {

    	// get settings
    	$mwcmSettings = get_option('mwcm_settings_array');

    	if(!function_exists('wp_get_current_user')) { 
    		include(ABSPATH . "wp-includes/pluggable.php"); 
    	}

		return ! ( current_user_can( 'administrator' ) && is_user_logged_in() && $mwcmSettings['mwcm_hide_admin'] == 'no' );
	}
    
	public function mwcm_mail_components($components, WPCF7_ContactForm $contact_form) {

		$mwcmSettings = get_option('mwcm_settings_array');

		if ( isset( $_REQUEST['mwcm-product-id'] ) ) {

			$post_id = $_REQUEST['mwcm-product-id'];

			if ( $contact_form->id() == $mwcmSettings['mwcm_select_shortcode'] ) {

				if ( $mwcmSettings['mwcm_cf7_proper'] == 'yes' ) {

					$form_atts    = $contact_form->get_properties();
					$field_label  = esc_html__( 'Related product', '' );
					$product      = wc_get_product( $post_id );
					$product_link = $product->get_permalink();
					$product_name = $product->get_formatted_name();

					if ( ! $form_atts['mail']['use_html'] ) {

						$field_data = "{$field_label}: {$product_name} - {$product_link}\n\n";

					} else {

						ob_start(); ?>
                        <p>
							<?php echo esc_attr($field_label); ?>: <a
                                href="<?php echo esc_attr($product_link); ?>"><?php echo esc_attr($product_name); ?></a>
                        </p>
						<?php $field_data = ob_get_clean();
					}

					$components['body'] = $field_data . $components['body'];
				}
			}
		}
	}

    public function mwcm_front_scripts_loading() {

    	global $post;

        wp_enqueue_script('jquery');

        wp_enqueue_script( 'mwcm-frontoffice', plugins_url( '../assets/js/frontoffice.js', __FILE__ ), false );

        wp_localize_script( 'mwcm-frontoffice', 'mwcm_data_vars', array(
                'mwcm_nonce' => wp_create_nonce('mwcm_nonce'),
                'ajax_url' => admin_url('admin-ajax.php'),
                'product_id' => $post->ID
            )
        );

        wp_enqueue_style('mwcm-front', plugins_url( '../assets/css/frontoffice.css', __FILE__ ), false );

        // getsettings
        $mwcmSettings = get_option('mwcm_settings_array');

        // button text color
        if(!empty($mwcmSettings['mwcm_text_color'])) {
            $textcolor = $mwcmSettings['mwcm_text_color'];
        }else {
            $textcolor = '#fff';
        }
        // button background color
        if(!empty($mwcmSettings['mwcm_backbtn_color'])) {
            $bgcolor = $mwcmSettings['mwcm_backbtn_color'];
        }else {
            $bgcolor = '#000';
        }
        // text hover color
        if(!empty($mwcmSettings['mwcm_hovbtn_color'])) {
            $texthcolor = $mwcmSettings['mwcm_hovbtn_color'];
        }else {
            $texthcolor = '#000';
        }
        // background hover color
        if(!empty($mwcmSettings['mwcm_bhovbtn_color'])) {
            $bghcolor = $mwcmSettings['mwcm_bhovbtn_color'];
        }else {
            $bghcolor = '#fff';
        }

        $custom_css = "
	        .mwcm_button_wrap a.mwcm_custom_button {
	            color: {$textcolor};
                background-color: {$bgcolor};
        	}
        	.mwcm_button_wrap a.mwcm_custom_button:hover {
	            color: {$texthcolor};
                background-color: {$bghcolor};
        	}";

        wp_add_inline_style( 'mwcm-front', $custom_css );

        wp_enqueue_style( 'mwcm-fontawesome-css', plugins_url( '../assets/css/font-awesome.min.css', __FILE__ ), false);
    }

} new WOOCOMMERCE_CATALOG_MODE_FRONT();