<?php 
/*
Plugin Name: Motif WooCommerce Catalog Mode
Plugin URI: http://demo.motif-solution.com/woocommerce-hide-price-hide-add-to-cart-plugin/shop/
Description: If you are looking for a tool to easily manage prices displayed on the product, category pages, and tag pages the WooCommerce Hide Price, Hide Add to Cart Button plugin is actually what you want.
Author: motifcreatives
Version: 1.0.4
Developed By: MotifCreatives
Author URI: https://codecanyon.net/item/woocommerce-hide-price-hide-add-to-cart-plugin/24391750
Support: http://support@extendons.com
textdomain: motif-woocommerce-catalog-mode
License: GPL-2.0+
License URI: http://www.gnu.org/licenses/gpl-2.0.txt
*/

// main class
class MOTIF_WOOCOMMERCE_CATALOG_MODE {

	public function __construct() {

		$this->mwcm_plugin_constent_urls();

		add_action( 'wp_loaded', array( $this, 'mwcm_loading_text_domain'));

		add_action( 'plugins_loaded', array( $this, 'mwcm_loading_text_domain' ), 100 );

		require_once( mwcm_dir.'backoffice/motif-woocommerce-catalog-mode-admin.php');
		require_once( mwcm_dir.'backoffice/motif-woocommerce-catalog-mode-settings.php');
        require_once( mwcm_dir.'frontoffice/motif-woocommerce-catalog-mode-front.php');
        add_action( 'wp_ajax_mwcm_admin_setting_save', array($this,'mwcm_admin_setting_save') );
	}

	// saving settings
	public function mwcm_admin_setting_save() {
		$settings_data = array();
        parse_str($_POST['data'], $settings_data);
        
        $settings_data['mwcm_func_enable'] = isset( $settings_data['mwcm_func_enable'] ) ? 'yes' : 'no';
        $settings_data['mwcm_hide_both_pri_atc'] = isset( $settings_data['mwcm_hide_both_pri_atc'] ) ? 'yes' : 'no';
        $settings_data['mwcm_hide_admin'] = isset( $settings_data['mwcm_hide_admin'] ) ? 'yes' : 'no';
        $settings_data['mwcm_cf7_proper'] = isset( $settings_data['mwcm_cf7_proper'] ) ? 'yes' : 'no';
        $settings_data['mwcm_cf7_enable'] = isset( $settings_data['mwcm_cf7_enable'] ) ? 'yes' : 'no';
        $settings_data['mwcm_customshop_enable'] = isset( $settings_data['mwcm_customshop_enable'] ) ? 'yes' : 'no';
        $settings_data['mwcm_customsingle_enable'] = isset( $settings_data['mwcm_customsingle_enable'] ) ? 'yes' : 'no';
        $settings_data['mwcm_newtab_link'] = isset( $settings_data['mwcm_newtab_link'] ) ? 'yes' : 'no';
        $settings_data['mwcm_disable_shop'] = isset( $settings_data['mwcm_disable_shop'] ) ? 'yes' : 'no';
              
        update_option('mwcm_settings_array', $settings_data);

        die();
	}

	// plugin constant
	public function mwcm_plugin_constent_urls() {

		if ( !defined( 'mwcm_url' ) )
	    define( 'mwcm_url', plugin_dir_url( __FILE__ ) );

	    if ( !defined( 'mwcm_basename' ) )
	    define( 'mwcm_basename', plugin_basename( __FILE__ ) );

	    if ( ! defined( 'mwcm_dir' ) )
	    define( 'mwcm_dir', plugin_dir_path( __FILE__ ) );
	}

	// text domain
	public function mwcm_loading_text_domain() {
		
		load_plugin_textdomain( 'motif-woocommerce-catalog-mode', false, basename( plugin_basename( __FILE__ ) ) . '/languages/' );
	}

	// enqueue scripts for main file
	public function mwcm_main_scripts() { 

		wp_enqueue_script( 'jquery' );	
	} 	

} new MOTIF_WOOCOMMERCE_CATALOG_MODE();
