(function ($) {
    'use strict';

    $.notificationXProPublic = $.notificationXProPublic || {};

    $(document).ready(function () {
        $.notificationXProPublic.init();
    });

    $.notificationXProPublic.init = function () {
        $.notificationXProPublic.analytics();
        $.notificationXProPublic.sound();
        // for shortcode
        var shortcodeWrapper = $('.notificationx-shortcode-wrapper');
        if (shortcodeWrapper.length > 0) {
            var height = $('.notificationx-shortcode-wrapper > div:first').outerHeight();
            shortcodeWrapper.css('height', height);
            var config = shortcodeWrapper.data('config');
            $.notificationXProPublic.shortcodeRender(config, shortcodeWrapper.html());
        }
    };

    $.notificationXProPublic.Ajaxlytics = function (data) {
        if (data == {} || data == undefined ) {
            return;
        }
        if( typeof NotificationX != 'undefined' ) {
            jQuery.ajax({
                type: 'POST',
                url: NotificationX.ajaxurl,
                data: {
                    action: 'notificationx_pro_analytics',
                    nonce: data.nonce,
                    id: data.id,
                    clicked: data.clicked || false,
                    nonce_key : data.nonce_key || false
                },
                success: function (response) {
                    // Response Code
                }
            });
        }
    };

    $.notificationXProPublic.analytics = function () {
        var data = {};
        // Bar Analytics nx_frontend_bar_show
        $('body').on('nx_frontend_bar_show', function (event, bar, bar_id) {
            var nonce = $(bar).data('nonce');
                data.nonce = nonce;
                data.id = bar_id;
                data.nonce_key = '_notificationx_bar_nonce';
            $.notificationXProPublic.Ajaxlytics(data);
            $(bar).on('click', function (e) {
                data.clicked = true;
                $.notificationXProPublic.Ajaxlytics(data);
                data.clicked = false;
            });
        });

        $('body').on('nx_before_render', function (event, configuration, html) {
            if (configuration.id) {
                var nonce = $(html).find('.notificationx-pro-analytics').val();
                data.nonce = nonce;
                data.id = configuration.id;
                data.nonce_key = '_notificationx_pro_analytics_nonce';
                $.notificationXProPublic.Ajaxlytics(data);
            }
        });
        $('body').on('nx_frontend_jquery', function (event, configuration, notification) {
            if (configuration.id) {
                $(notification).on('click', function (e) {
                    var nonce = $(this).find('.notificationx-pro-analytics').val();
                    data.nonce = nonce;
                    data.id = configuration.id;
                    data.nonce_key = '_notificationx_pro_analytics_nonce';
                    data.clicked = true;
                    $.notificationXProPublic.Ajaxlytics(data);
                    data.clicked = false;
                });
            }
        });
    };

    $.notificationXProPublic.sound = function () {
        $('body').on('nx_frontend_jquery', function (event, configuration, notification) {
            if (configuration.sound == '1') {
                var sound = $(notification).find('audio');
                sound = sound[0];
                sound.volume = parseFloat(configuration.volume);
                sound.muted = false;
                var promise = sound.play();
                // TODO: something to do with DOM Promise
                if (promise !== undefined) {
                    promise.then(function () {
                        // console.log( promise.value );
                    }).catch(function (e) {
                        console.log('error: ', e);
                    });
                }
            }
        });
    };
    /**
     * For Shortcode Notification Render
     */
    $.notificationXProPublic.shortcodeRender = function (configuration, html) {
        var notificationHTML = document.createElement('div');
        notificationHTML.classList.add('notificationx-conversions-shortcode');
        notificationHTML.insertAdjacentHTML('beforeend', html);

        var count = 0,
            notifications = notificationHTML.querySelectorAll('.notificationx-' + configuration.id),
            delayBetween = configuration.delay_between,
            last = $.notificationx.last(configuration.id, false);

        if (last >= 0) {
            count = last + 1;
        }

        if( notifications.length === 1 ) {
            count = 0;
        }

        if (configuration.loop === 0 && notifications.length === 1) {
            count = 0;
        }

        $('body').trigger('nx_before_render', [configuration, html]);
        setTimeout(function () {
            $.notificationXProPublic.shortcodeShow(notifications[count], configuration, count);
            setTimeout(function () {
                if (configuration.loop !== 0) {
                    $.notificationXProPublic.shortcodeHide(notifications[count], count);
                }
                count++;
                var nextNotification = setInterval(function () {
                    $.notificationXProPublic.shortcodeShow(notifications[count], configuration, count);
                    setTimeout(function () {
                        $.notificationXProPublic.shortcodeHide(notifications[count], count);
                        if (count >= notifications.length - 1) {
                            count = 0;
                            if (configuration.loop === 0) {
                                clearInterval(nextNotification);
                            }
                        } else {
                            count++;
                        }
                    }, configuration.display_for);
                }, delayBetween + configuration.display_for);
            }, configuration.display_for);
        }, configuration.delay_before);
    };
    /**
     * Shortcode Single Notification Show
     */
    $.notificationXProPublic.shortcodeShow = function (notification, configuration, count) {
        if ('undefined' === typeof notification || 0 === notification.length) {
            return;
        }
        var htmls = $('.notificationx-shortcode-wrapper > div');
        var body = $('body');
        $(htmls[count]).addClass('nx-animate').animate({
            'opacity' : 1,
        }, 500);
        body.trigger('nx_frontend_jquery', [configuration, notification]);
        var nxClose = $(notification).find('.notificationx-close');
        if (nxClose != null) {
            nxClose.on('click', function (event) {
                var close = $(this);
                var parent = $(close[0]).parents('.nx-notification');
                $.notificationXProPublic.shortcodeHide(parent);
            });
        }
    };
    /**
     * Shortcode Single Notification Hide
     */
    $.notificationXProPublic.shortcodeHide = function (notification, count) {
        if (notification === undefined) {
            return;
        }
        if (Cookies.get('nx-close-for-session')) {
            return;
        }
        var htmls = $('.notificationx-shortcode-wrapper > div');
        $(htmls[count]).animate({
            'opacity' : 0
        }, 500, 'swing', function(){
            $(this).removeClass('nx-animate');
        });
    };
})(jQuery);