<?php
/**
* This Class is responsible for making mailchimp activity
* notifications.
*/
class NotificationXPro_Zapier_Extension extends NotificationX_Extension {
    /**
    *  Type of notification.
    * @var string
    */
    public  $type     = 'zapier';
    public  $template = 'mailchimp_template';
    public  $themeName = 'mailchimp_theme';
    public  $meta_key = 'zapier_content';
    public  $api_key = '';
    public $notifications = array();
    
    public function __construct() {
        parent::__construct();
        /**
         * @since 1.1.3
         */
        add_action( 'add_meta_boxes',array( $this, 'add_metabox' ) );
        add_action( 'nx_api_response_success', array( $this, 'get_response' ) );
        add_action( 'nx_notification_image_action', array( $this, 'image_action' ) );
        add_filter( 'nx_data_key', array( $this, 'key' ), 10, 2 );
    }
    /**
     * Instructions Box
     * @since 1.1.3
     */
    public function add_metabox(){
        add_meta_box( 'nxpro-zapier-instructions', __( 'Zapier setup instructions', 'notificationx-pro' ), array( $this,'metabox_content'), 'notificationx', 'side' );
    }
    /**
     * Instructions Content
     * @since 1.1.3
     */
    public function metabox_content(){
        ob_start();
        ?>
        <div class="instructions-wrapper">
            <div class="instructions-header">
                <i class="dashicons dashicons-info"></i>
                <span class="title"><?php _e('Zapier setup Instructions', 'notificationx-pro'); ?></span>
            </div>
            <div class="instructions">
                <p><?php 
                    $format = sprintf('Make sure that you have <a target="_blank" rel="nofollow" href="%1$s">created a Zap</a> with your preferred Application. From Zap Builder, you need to choose <strong>NotificationX</strong> as your Action App. You can get the public invitation link from <a href="%2$s" target="_blank" rel="nofollow">here</a>', 'https://zapier.com/learn/getting-started-guide/build-zap-workflow', 'https://zapier.com/developer/public-invite/28239/62de3486b323cd5830e27b251183a456' );
                    _e( $format, 'notificationx-pro' );
                ?></p>
                <p><?php 
                    $format = sprintf("For further assistance, check out this <a href='%s' rel='nofollow'>Documentation</a>", "https://notificationx.com/docs/zapier-notification-alert/");
                    _e( $format, 'notificationx-pro' );
                ?>
                </p>
            </div>
        </div>
        <?php
        return ob_get_flush();
    }
    public static function get_notification_ready( $type, $data = [] ) {
        return;
    }
    /**
    * This method is used for fallback data
    * @since 1.1.2
    */
    public function fallback_data( $data, $saved_data, $settings ){
        if( NotificationX_Helper::get_type( $settings ) !== $this->type ) {
            return $data;
        }
        
        if( isset( $saved_data['display_type'] ) && $saved_data['display_type'] == 2 ) {
            if( ! isset( $saved_data['username'] ) ) {
                $data['username'] = __('Someone', 'notificationx-pro');
            }

            if( ! isset( $saved_data['plugin_name'] ) ) {
                $data['plugin_name'] = __('', 'notificationx-pro');
            }

            if( ! isset( $saved_data['plugin_review'] ) && isset( $saved_data['content'] ) ) {
                $data['plugin_review'] = __($saved_data['content'], 'notificationx-pro');
            }
            
            if( ! isset( $saved_data['rating'] ) ) {
                $data['rating'] = 5;
            }
        }
        
        return $data;
    }
    
    public function key( $key, $settings ){
        if( $settings->display_type === 'email_subscription' && $settings->subscription_source === 'zapier' ) {
            $key = $key . '_' . $settings->id;
        }
        
        if( $settings->display_type === 'reviews' && $settings->reviews_source === 'zapier' ) {
            $key = $key . '_' . $settings->id;
        }
        
        if( $settings->display_type === 'conversions' && $settings->conversion_from === 'zapier' ) {
            $key = $key . '_' . $settings->id;
        }
        
        return $key;
    }
    
    public function get_response( $response ){
        if ( isset( $response['id'] ) ) {
            $response['entry_id'] = time();
            $response['timestamp'] = time();
            
            if( isset( $response['ip'] ) ) {
                $remote_response = self::remote_get( 'http://ip-api.com/json/' . $response['ip'] );
                
                if( $remote_response ) {
                    $response['country'] = $remote_response->country;
                    $response['city'] = $remote_response->country;
                }
            }
            
            if( isset( $response['display_type'] ) && $response['display_type'] == 2 ) {
                if( isset( $response['plugin_name'] ) && empty( $response['plugin_name'] ) ) {
                    $response['plugin_name'] = $response['plugin_name'];
                }
            }
            
            $key = $this->type . '_' . $response['id'];
            
            if( isset( $response['display_type'] ) && $response['display_type'] == 1 ) {
                $products = $this->extract_data( $response['products'] );
                unset( $response['products'] );
                if( ! empty( $products ) ) {
                    foreach( $products as $product ) {
                        $product_item = array_merge($response, $product);
                        $this->save( $key, $product_item, $response['timestamp'] );
                    }
                    return true;
                }
            }
            
            $this->save( $key, $response, $response['timestamp'] );
        }
    }
    
    public function init_hooks(){
        add_filter( 'nx_email_subscription_source', array( $this, 'toggle_fields' ) );
        add_filter( 'nx_conversion_from', array( $this, 'conversion_toggle_fields' ) );
        add_filter( 'nx_reviews_source', array( $this, 'reviews_toggle_fields' ) );
    }
    
    public function init_builder_hooks(){
        add_filter( 'nx_builder_tabs', array( $this, 'builder_toggle_fields' ) );
    }
    /**
    * This function is responsible for render toggle data for conversion
    *
    * @param array $options
    * @return void
    */
    public function toggle_fields( $options ) {
        $fields = array();
        $fields = array_merge( NotificationX_ToggleFields::common_fields(), $fields, array( 'mailchimp_template_new', 'mailchimp_template_adv' ) );
        
        $options['dependency'][ $this->type ]['fields'] = $fields;
        $options['dependency'][ $this->type ]['sections'] = ['image', 'mailchimp_themes'];
        $options['hide'][ $this->type ]['fields'] = [ 'mailchimp_list', 'has_no_edd', 'has_no_woo' ];
        
        return $options;
    }
    
    public function conversion_toggle_fields( $options ) {
        $fields = array();
        $fields = array_merge( NotificationX_ToggleFields::common_fields(), $fields, array( 'conversion_from', 'show_notification_image', 'woo_template_new', 'woo_template_adv') );
        
        $options['dependency'][ $this->type ]['fields'] = $fields;
        $options['dependency'][ $this->type ]['sections'] = ['themes', 'image', 'conversion_link_options'];     
        $options['hide'][ $this->type ][ 'fields' ] = [ 'woo_template', 'has_no_edd', 'has_no_woo', 'product_control', 'product_exclude_by', 'product_list', 'category_list', 'exclude_categories', 'exclude_products', 'edd_product_control', 'edd_product_exclude_by', 'edd_product_list', 'edd_category_list', 'edd_exclude_categories', 'edd_exclude_products', 'custom_contents', 'show_custom_image' ];
        return $options;
    }
    public function reviews_toggle_fields( $options ) {
        $options['dependency'][ $this->type ]['fields'] = array( 'wp_reviews_template_new', 'review_saying_template_new', 'wp_reviews_template_adv', 'show_notification_image' );
        $options['dependency'][ $this->type ]['sections'] = array( 'wporg_themes' );
        return $options;
    }
    
    public function builder_toggle_fields( $options ) {
        $fields = array();
        $sections = array();
        
        $options['source_tab']['sections']['config']['fields']['display_type']['dependency'][ $this->type ]['fields'] = array_keys( $fields );
        $options['source_tab']['sections']['config']['fields']['display_type']['dependency'][ $this->type ]['sections'] = array_keys( $sections );
        return $options;
    }
    
    public function image_action(){
        add_filter( 'nx_notification_image', array( $this, 'notification_image' ), 10, 3 );
    }
    
    public function notification_image( $image_data, $data, $settings ){
        if( NotificationX_Helper::get_type( $settings ) != 'zapier' ) { 
            return $image_data;
        }
        
        $avatar = '';
        $alt_title = isset( $data['title'] ) ? $data['title'] : '';
        $alt_title = empty( $alt_title ) && isset( $data['plugin_name'] ) ? $data['plugin_name'] : $alt_title;
        
        if( isset( $data['review_from'] ) && $data['review_from'] == 'twitter' && ! isset( $data['avatar'] ) ) {
            $avatar = NOTIFICATIONX_PRO_URL . 'assets/images/icons/twitter.png';
        }

        if( isset( $data['review_from'] ) && $data['review_from'] == 'facebook' && ! isset( $data['avatar'] ) ) {
            $avatar = NOTIFICATIONX_PRO_URL . 'assets/images/icons/facebook.png';
        }

        if( isset( $data['avatar'] ) && ! empty( $data['avatar'] ) ) {
            $avatar = $data['avatar'];
        }
        
        $image_data['url'] = $avatar;
        $image_data['alt'] = $alt_title;
        
        return $image_data;
    }
    
    /**
    * This functions is hooked
    * 
    * @hooked nx_public_action
    *
    * @return void
    */
    public function public_actions(){
        if( ! $this->is_created( $this->type ) ) {
            return;
        }
    }
    public function admin_actions(){
        if( ! $this->is_created( $this->type ) ) {
            return;
        }
    }
    
    public function frontend_html( $data = [], $settings = false, $args = [] ){
        if( $settings->display_type === 'reviews' ) {
            $args['template'] = 'wp_reviews_template';
            $args['themeName'] = 'wporg_theme';
            if( ! isset( $data['rating'] ) ) {
                $data['rating'] = 5;
            }
            if( ! empty( $data['rating'] ) ) {
                for( $i = 1; $i <= $data['rating']; $i++ ) {
                    $star .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="14" height="13" viewBox="0 0 14 13"><metadata><?xpacket begin="﻿" id="W5M0MpCehiHzreSzNTczkc9d"?><x:xmpmeta xmlns:x="adobe:ns:meta/" x:xmptk="Adobe XMP Core 5.6-c138 79.159824, 2016/09/14-01:09:01"><rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"><rdf:Description rdf:about=""/></rdf:RDF></x:xmpmeta><?xpacket end="w"?></metadata><image id="Capa_1_copy" data-name="Capa 1 copy" width="14" height="13" xlink:href="data:img/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAANCAMAAACuAq9NAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAn1BMVEXtihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihntihkAAAALB0bHAAAAM3RSTlMAAYjPGfNomdENAytlBJKtx+b87dKzpeIHvOksC6/eJPX6NzoaZ2PufFnbqlx/EgZXzp2UDFIsAAAAAWJLR0Q0qbHp/QAAAAlwSFlzAAALEgAACxIB0t1+/AAAAAd0SU1FB+MGDA4JMRMQH+0AAABvSURBVAjXY2AAAUYmZgYkwMJqzIbEZTc25uCEcbi4jYGAhxfE5uMXEBQCcY2FRUTFGMSNkQGDhCSCIyXNwCAjC+PJyYONUoDwFJUgJsNklcE8FRhXFcxVMzZW19DUMjbWBnN1BHX1GBj0DQyNGBgA1A4SzLVFctoAAAAASUVORK5CYII="/></svg> ';
                }
                $data['rating'] = $star;
            }
        }
        
        if( $settings->display_type === 'conversions' ) {
            $args['template'] = 'woo_template';
            $args['themeName'] = 'theme';
        }
        
        return parent::frontend_html( $data, $settings, $args );
    }
    
    protected function extract_data( $data ) {
        if( empty( $data ) ) {
            return [];
        }
        
        $new_data = [];
        $i = 0;
        
        $data = explode("\n", $data);
        foreach( $data as $value ) {
            if( empty( $value ) ){
                $i++;
                continue;
            }
            $inner_array = explode(":", $value);
            if( is_array( $inner_array ) ) {
                if( $inner_array[0] === 'product_id' ) {
                    $new_data[$i]['product_id'] = trim( $inner_array[1] );
                }
                if( $inner_array[0] === 'name' ) {
                    $new_data[$i]['title'] = trim( $inner_array[1] );
                }
            }
            $inner_array = [];
        }
        
        return $new_data;
    }
}