<?php

class QuadMenu_PRO_License extends QuadMenu_Panel {

  static $panel_slug = 'quadmenu_welcome';

  function __construct() {
    add_action('admin_menu', array($this, 'add_menu'));
    add_action('admin_init', array($this, 'remove_purchase_page'));
    add_action('admin_init', array($this, 'add_activation'));
    add_action('admin_init', array($this, 'add_settings'));
  }

  function add_menu() {
    add_submenu_page(self::$panel_slug, esc_html__('License', 'quadmenu'), sprintf('%s', esc_html__('License', 'quadmenu')), 'edit_posts', self::$panel_slug . '_license', array($this, 'add_panel'));
  }

  function add_panel() {
    global $submenu, $quadmenu_license, $quadmenu_updater;

    $defaults = array(
        'market' => null,
        'license_key' => null,
        'email' => null,
    );

    $quadmenu_license = (object) wp_parse_args(get_option(QUADMENU_DOMAIN . '_license'), (array) $defaults);

    include (QUADMENU_PLUGIN_DIR . '/includes/panel/pages/parts/header.php');
    include (QUADMENU_PRO_PLUGIN_DIR . '/includes/panel/pages/license.php');
  }

  function add_settings() {
    register_setting(sanitize_key(QUADMENU_DOMAIN . '_license-group'), sanitize_key(QUADMENU_DOMAIN . '_license'));
  }

  function remove_purchase_page() {
    remove_submenu_page('quadmenu_welcome', 'quadmenu_welcome_premium');
  }

  function add_activation() {

    global $quadmenu_updater;

    if (isset($_POST['option_page']) && $_POST['option_page'] == QUADMENU_DOMAIN . '_license-group' && isset($_POST[QUADMENU_DOMAIN . '_license'])) {
      $quadmenu_updater->request_activation($_POST[QUADMENU_DOMAIN . '_license']['license_key'], $_POST[QUADMENU_DOMAIN . '_license']['email'], $_POST[QUADMENU_DOMAIN . '_license']['market']);
    }
  }

}

new QuadMenu_PRO_License();
