<?php
/**
 * Copyright 2015 Dirk Groenen
 *
 * (c) Dirk Groenen <dirk@bitlabs.nl>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace DirkGroenen\Pinterest\Tests\Endpoints;

use \DirkGroenen\Pinterest\Pinterest;
use \DirkGroenen\Pinterest\Tests\Utils\CurlBuilderMock;

class AuthTest extends \PHPUnit_Framework_TestCase{

    /**
     * The Pinterest instance
     *
     * @var Pinterest
     */
    private $pinterest;

    /**
     * Setup a new instance of the Pinterest class
     *
     * @return void
     */
    public function setUp()
    {
        $curlbuilder = CurlBuilderMock::create( $this );

        // Setup Pinterest
        $this->pinterest = new Pinterest("0", "0", $curlbuilder);
        $this->pinterest->auth->setOAuthToken( "0" );
    }

    public function testRandomStateIsSet()
    {
        $state = $this->pinterest->auth->getState();

        $this->assertNotEmpty( $state );
    }

    public function testSetState()
    {
        $state = substr( md5( rand() ), 0, 7 );
        $this->pinterest->auth->setState($state);

        $this->assertEquals( $this->pinterest->auth->getState(), $state );
    }
}
