<?php

namespace TheLion\UseyourDrive\Integrations\Elementor;

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

class Widget extends \Elementor\Widget_Base
{
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);

        wp_register_script('UseyourDrive.Elementor.Widget', plugins_url('widget.js', __FILE__), ['jquery'], USEYOURDRIVE_VERSION);
    }

    public function is_editor()
    {
        return is_admin() && (isset($_GET['action']) && 'elementor' === $_GET['action']) || (isset($_REQUEST['elementor-preview']));
    }

    public function get_script_depends()
    {
        $a = $this->is_editor();
        if (false === $this->is_editor()) {
            return [];
        }

        global $UseyourDrive;

        $mediaplayer = $UseyourDrive->get_processor()->load_mediaplayer($UseyourDrive->settings['mediaplayer_skin']);

        if (!empty($mediaplayer)) {
            $mediaplayer->load_scripts();
            $mediaplayer->load_styles();
        }

        return ['UseyourDrive.UploadBox', 'UseyourDrive', 'UseyourDrive.Elementor.Widget'];
    }

    public function get_style_depends()
    {
        if (false === $this->is_editor()) {
            return [];
        }

        global $UseyourDrive;
        $UseyourDrive->load_custom_css();

        return ['Awesome-Font-5-css', 'UseyourDrive.ShortcodeBuilder', 'UseyourDrive'];
    }

    public function is_reload_preview_required()
    {
        return true;
    }

    public function get_name()
    {
        return 'wpcp-useyourdrive';
    }

    public function get_title()
    {
        return 'Google Drive';
    }

    public function get_icon()
    {
        return 'eicon-cloud-check';
    }

    public function get_categories()
    {
        return ['wpcloudplugins'];
    }

    public function get_keywords()
    {
        return ['cloud', 'google', 'drive', 'documents', 'files', 'upload', 'video', 'audio', 'media', 'embed'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Shortcode', 'wpcloudplugins'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shortcode',
            [
                'label' => __('Raw shortcode', 'wpcloudplugins'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => __('Edit this shortcode via the Shortcode Builder or manually via the raw code', 'wpcloudplugins'),
                'default' => '[useyourdrive mode="files"]',
                'rows' => 7,
            ]
        );

        $this->add_control(
            'edit_shortcode',
            [
                'type' => \Elementor\Controls_Manager::BUTTON,
                'show_label' => false,
                'text' => __('Edit via Shortcode Builder', 'wpcloudplugins'),
                'event' => 'wpcp:editor:edit_useyourdrive_shortcode',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $html = $this->get_render_html($settings['shortcode']);

        echo ($html) ? $html : $settings['shortcode'];
    }

    protected function get_render_html($shortcode)
    {
        if (empty($shortcode)) {
            return __('Please create your shortcode first', 'wpcloudplugins');
        }

        \ob_start();

        echo do_shortcode($shortcode);

        $content = \ob_get_clean();

        if (empty($content)) {
            return '';
        }

        return $content;
    }
}
