@extends('tools.base.tool-container', [
    'id' => 'tool-clear-urls'
])

@section('title')
    {{ _wpcc("Clear URLs") }}
@overwrite

@section('content')
    <form action="" class="tool-form">
        {{--{!! wp_nonce_field('wcc-tools', \WPCCrawler\Environment::nonceName()) !!}--}}

        @include('partials.form-nonce-and-action')
        <input type="hidden" name="tool_type" value="delete_urls">

        <div class="panel-wrap">

            <table class="wcc-settings">
                {{-- SITE --}}
                <tr>
                    <td>
                        @include('form-items/label', [
                            'for'   =>  \WPCCrawler\Objects\Settings\Enums\SettingKey::WPCC_TOOLS_CLEAR_URLS_SITE_ID,
                            'title' =>  _wpcc('Site'),
                            'info'  =>  _wpcc('Select the site whose URLs you want to be deleted from the database.'),
                        ])
                    </td>
                    <td>
                        @include('form-items/select', [
                            'name'      =>  \WPCCrawler\Objects\Settings\Enums\SettingKey::WPCC_TOOLS_CLEAR_URLS_SITE_ID,
                            'options'   =>  $sites,
                        ])
                    </td>
                </tr>

                {{-- URL TYPE --}}
                <tr>
                    <td>
                        @include('form-items/label', [
                            'for'   =>  \WPCCrawler\Objects\Settings\Enums\SettingKey::WPCC_TOOLS_URL_TYPE,
                            'title' =>  _wpcc('URL Type'),
                            'info'  =>  _wpcc('Select URL types to be cleared for the specified site. If you clear the URLs
                                waiting in the queue, those URLs will not be saved, unless they are collected again. If you
                                clear already-saved URLs, those URLs may end up in the queue again, and they may be saved
                                as posts again. So, you may want to delete the posts as well, unless you want duplicate content.'),
                        ])
                    </td>
                    <td>
                        @include('form-items/select', [
                            'name'      =>  \WPCCrawler\Objects\Settings\Enums\SettingKey::WPCC_TOOLS_URL_TYPE,
                            'options'   =>  $urlTypes,
                        ])
                    </td>
                </tr>

                {{-- SAFETY CHECK --}}
                <tr>
                    <td>
                        @include('form-items/label', [
                            'for'   =>  \WPCCrawler\Objects\Settings\Enums\SettingKey::WPCC_TOOLS_SAFETY_CHECK,
                            'title' =>  _wpcc("I'm sure"),
                            'info'  =>  _wpcc('Check this to indicate that you are sure about this.'),
                        ])
                    </td>
                    <td>
                        @include('form-items/checkbox', [
                            'name'      =>  \WPCCrawler\Objects\Settings\Enums\SettingKey::WPCC_TOOLS_SAFETY_CHECK,
                        ])
                    </td>
                </tr>
            </table>

            @include('form-items/submit-button', [
                'text'  =>  _wpcc('Delete URLs')
            ])

            @include('partials/test-result-container')

        </div>
    </form>
@overwrite
