<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) { exit; }

$module_helper = cjwpbldr_frontend_auth_helpers::getInstance();
$edit_profile_form = $module_helper->postInfo( 'cjwpbldr_frontend_auth_do_edit_profile' );

$edit_profile_form_fields = (array_key_exists( 'ID', $edit_profile_form )) ? $module_helper->getFormFields( $edit_profile_form['ID'] ) : '';

$general_variables = array(
	'site_url' => __( 'This will display website url.', 'addon-frontend-auth' ),
	'site_name' => __( 'This will display website name.', 'addon-frontend-auth' ),
);

$page_urls = array(
	'login_url' => __( 'Login page Url that is selected under Configuration > Default Pages.', 'addon-frontend-auth' ),
	'register_url' => __( 'Register page Url that is selected under Configuration > Default Pages.', 'addon-frontend-auth' ),
	'forgot_password_url' => __( 'Forgot Password page Url that is selected under Configuration > Default Pages.', 'addon-frontend-auth' ),
	'edit_profile_url' => __( 'Edit Profile page Url that is selected under Configuration > Default Pages.', 'addon-frontend-auth' ),
	'logout_url' => __( 'Logout page Url that is selected under Configuration > Default Pages.', 'addon-frontend-auth' ),
);

$page_urls_links = array(
	'login_link' => __( 'Login page link that is selected under Configuration > Default Pages.', 'addon-frontend-auth' ),
	'register_link' => __( 'Register page link that is selected under Configuration > Default Pages.', 'addon-frontend-auth' ),
	'forgot_password_link' => __( 'Forgot Password page link that is selected under Configuration > Default Pages.', 'addon-frontend-auth' ),
	'edit_profile_link' => __( 'Edit Profile page link that is selected under Configuration > Default Pages.', 'addon-frontend-auth' ),
	'logout_link' => __( 'Logout page link that is selected under Configuration > Default Pages.', 'addon-frontend-auth' ),
);

$general_variables_array = apply_filters( 'cjwpbldr_email_variables_general', $general_variables, 10, 1 );
$form_fields[] = array(
	'id' => 'general-variable-heading',
	'label' => __( 'General Variables', 'addon-frontend-auth' ),
	'type' => 'heading',
	'default' => '',
	'options' => '', // array in case of dropdown, checkbox and radio buttons
);
foreach( $general_variables_array as $variable => $info ) {
	$form_fields[] = array(
		'id' => 'variable-info-' . $variable,
		'label' => '<span class="cj-text-normal">%' . $variable . '%</span>',
		'type' => 'info',
		'default' => $info,
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	);
}

$form_fields[] = array(
	'id' => 'page-urls-variable-heading',
	'label' => __( 'Auth Page Urls', 'addon-frontend-auth' ),
	'type' => 'sub-heading',
	'default' => '',
	'options' => '', // array in case of dropdown, checkbox and radio buttons
);
$page_urls = apply_filters( 'cjwpbldr_email_variables_general', $page_urls, 10, 1 );
foreach( $page_urls as $variable => $info ) {
	$form_fields[] = array(
		'id' => 'variable-info-' . $variable,
		'label' => '<span class="cj-text-normal">%' . $variable . '%</span>',
		'type' => 'info',
		'default' => $info,
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	);
}

$page_urls_links = apply_filters( 'cjwpbldr_email_variables_general', $page_urls_links, 10, 1 );
foreach( $page_urls_links as $variable => $info ) {
	$form_fields[] = array(
		'id' => 'variable-info-' . $variable,
		'label' => '<span class="cj-text-normal">%' . $variable . '%</span>',
		'type' => 'info',
		'default' => $info,
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	);
}

$api_token_key = $this->helpers->savedOption( 'api_token_key' );
$api_token_expire_key = $this->helpers->savedOption( 'api_token_expire_key' );

$exclude_user_variables = array(
	'cjwpbldr_user_salt',
	'X-Authorization',
	'X-Authorization-Expires',
	'user_pass',
	'user_pass_confirmation',
	'password_heading',
	$api_token_key,
	$api_token_expire_key,
);

$user_variables_array = [];

if( ! empty( $edit_profile_form_fields ) ) {
	foreach( $edit_profile_form_fields as $key => $value ) {

		if( ! in_array( $value['id'], $exclude_user_variables ) ) {
			$user_variables_array[ $value['id'] ] = sprintf( __( 'This will display user %s', 'addon-frontend-auth' ), $value['id'] );
		}
	}

}

$form_fields[] = array(
	'id' => 'user-variable-heading',
	'label' => __( 'User Variables', 'addon-frontend-auth' ),
	'type' => 'sub-heading',
	'default' => '',
	'options' => '', // array in case of dropdown, checkbox and radio buttons
);

$user_variables_array = apply_filters( 'cjwpbldr_email_variables_user', $user_variables_array, 10, 1 );
foreach( $user_variables_array as $variable => $info ) {
	$form_fields[] = array(
		'id' => 'variable-info-' . $variable,
		'label' => '<span class="cj-text-normal">%' . $variable . '%</span>',
		'type' => 'info',
		'default' => $info,
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	);
}

return $form_fields;
