<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

$login_ip_info = array(
	'ip_address' => __( 'IP address', 'addon-frontend-auth' ),
	'last_login' => __( 'Last login timestamp', 'addon-frontend-auth' ),
	'location' => __( 'Geo location', 'addon-frontend-auth' ),
	'timezone' => __( 'Timezone', 'addon-frontend-auth' ),
	'country' => __( 'Country', 'addon-frontend-auth' ),
	'region' => __( 'Region', 'addon-frontend-auth' ),
	'city' => __( 'City', 'addon-frontend-auth' ),
	'postcode' => __( 'Postcode', 'addon-frontend-auth' ),
);

$roles = $this->helpers->getWPUserRoles();

$cjfmr_login_page_for_users_options = array(
	'hide_form_show_message' => __( 'Hide form and show this message', 'addon-frontend-auth' ),
	'login_page_redirect' => __( 'Redirect to this Url', 'addon-frontend-auth' ),
);

return [
	[
		'type' => 'heading',
		'id' => 'cjfmr_login_page_settings_heading',
		'label' => __( 'Login Page', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_login_page_redirect',
		'label' => __( 'Redirect Users', 'addon-frontend-auth' ),
		'info' => __( 'Redirect logged in users to this Url when they visit the login page selected under Page Setup.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => $this->helpers->queryString( site_url() ) . 'status=logged-in',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'sub-heading',
		'id' => 'cjfmr_login_options_heading',
		'label' => __( 'Capture User Info', 'addon-frontend-auth' ),
		'info' => __( 'Choose what additional information we should save about the user.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'multi-dropdown',
		'id' => 'cjfmr_login_save_user_info',
		'label' => __( 'What should we save?', 'addon-frontend-auth' ),
		'label_suffix' => sprintf( __( 'This will try to fetch and save user information from <a href="%s" target="_blank">%s</a>.', 'addon-frontend-auth' ), 'http://ip-api.com/php/', 'http://ip-api.com' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => array('country', 'location', 'timezone', 'ip_address', 'last_login'),
		'options' => $login_ip_info, // array in case of dropdown, checkbox and radio buttons
	]
];
