<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

$verify_password_url = $this->helpers->queryString( site_url( '/' ) ) . '<span class="color-brand-success text-bold">' . $this->helpers->savedOption( 'cjfmr_password_verification_key' ) . '</span>=unique-key';

$after_new_password_options = array(
	'auto_login' => __( 'Auto login the user and redirect', 'addon-frontend-auth' ),
	'show_login' => __( 'Show login page instead', 'addon-frontend-auth' ),
);

return [
	[
		'type' => 'heading',
		'id' => 'cjfmr_password_page_settings_heading',
		'label' => __( 'Password Page', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_password_page_redirect',
		'label' => __( 'Redirect Users', 'addon-frontend-auth' ),
		'info' => __( 'Redirect logged in users to this Url when they visit the forgot password page selected under Page Setup.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => $this->helpers->queryString( site_url() ) . 'show=edit-profile-page',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],

	[
		'type' => 'sub-heading',
		'id' => 'cjfmr_password_settings_heading',
		'label' => __( 'Global Password Settings', 'addon-frontend-auth' ),
		'info' => __( 'Here you can manage default password settings.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'number',
		'id' => 'cjfmr_min_password_length',
		'label' => __( 'Minimum Password Length', 'addon-frontend-auth' ),
		'info' => __( 'Specify minimum length for the user password.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => 6,
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'dropdown',
		'id' => 'cjfmr_strong_password',
		'label' => __( 'Force Strong Password', 'addon-frontend-auth' ),
		'info' => __( 'If <b>Yes</b>, user must input a password which has at least one uppercase letter, one lowercase letter, one number and one special character.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => 'yes',
		'options' => $this->helpers->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'radio-inline',
		'id' => 'cjfmr_show_password_meter',
		'label' => __( 'Show password strength', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 'yes',
		'options' => $this->helpers->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'sub-heading',
		'id' => 'cjfmr_reset_password_heading',
		'label' => __( 'Reset Password Process', 'addon-frontend-auth' ),
		'info' => __( 'Here you can manage settings related to password reset process.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_password_verification_key',
		'label' => __( 'Query String Key', 'addon-frontend-auth' ),
		'info' => sprintf( __( 'Specify the key to be used for password verification url.<br>e.g. %s', 'addon-frontend-auth' ), $verify_password_url ),
		'suffix' => '',
		'prefix' => '',
		'default' => 'reset-password',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
];