<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

$registration_status = (get_option( 'users_can_register' ) != 0) ? __( '<b class="cj-color-success">enabled</b>', 'addon-frontend-auth' ) : __( '<b class="cj-color-danger">disabled</b>', 'addon-frontend-auth' );
if( is_multisite() ) {
	$registration_status_url = admin_url( 'network/settings.php?updated=true' );
} else {
	$registration_status_url = admin_url( 'options-general.php' );
}

$cjfmr_verify_email_address_key = $this->helpers->savedOption( 'cjfmr_verify_email_address_key' );

$verify_email_address_url = $this->helpers->queryString( site_url() ) . '<b class="cj-color-success">' . $cjfmr_verify_email_address_key . '</b>=unique-key';

return [
	[
		'type' => 'heading',
		'id' => 'cjfmr_registration_setup_heading',
		'label' => __( 'Registration Settings', 'addon-frontend-auth' ),
		'info' => 'Here you can manage registration settings.',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'info',
		'id' => 'cjfmr_registration_status_info',
		'label' => __( 'Defaults', 'addon-frontend-auth' ),
		'info' => 'Here you can manage registration settings.',
		'suffix' => '',
		'prefix' => '',
		'default' => sprintf( __( 'Registrations are currently %s and Default Role is set to: <b>%s</b>.', 'addon-frontend-auth' ), $registration_status, get_option( 'default_role' ) ) . '<br>' .
		             sprintf( __( '<a href="%s">Click here</a> to manage the settings.', 'addon-frontend-auth' ), $registration_status_url ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_register_page_redirect',
		'label' => __( 'Redirect Users', 'addon-frontend-auth' ),
		'info' => __( 'Redirect logged in users to this Url when they visit the register page selected under Page Setup.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => $this->helpers->queryString( site_url() ) . 'status=already-registered',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_verify_email_address_key',
		'label' => __( 'Query String Key', 'addon-frontend-auth' ),
		'label_suffix' => __( 'Verify Email Address', 'addon-frontend-auth' ),
		'info' => sprintf( __( 'Specify the key to be used in email verification url.<br>e.g. %s', 'addon-frontend-auth' ), $verify_email_address_url ),
		'suffix' => '',
		'prefix' => '',
		'default' => 'verify-account',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
];