<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

return [
	//Restrict Content
	[
		'type' => 'heading',
		'id' => 'cjfmr_restricted_content_heading',
		'label' => __( 'Restrict Content', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'radio-inline',
		'id' => 'cjfmr_restrict_site',
		'label' => __( 'Restrict Whole Website', 'addon-frontend-auth' ),
		'info' => __( 'Choose yes if you wish to restrict all website pages except login, register and reset password page setup under this plugin settings.<p><b>NOTE:</b> If you select yes                      here, below settings will be overwritten.</p>', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => 'no',
		'options' => $this->helpers->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'radio-inline',
		'id' => 'cjfmr_restrict_site_except_home',
		'label' => __( 'Restrict Whole Website Except Homepage', 'addon-frontend-auth' ),
		'info' => __( 'Choose yes if you wish to restrict all website pages except home, login, register and reset password page setup under this plugin settings.<p><b>NOTE:</b> If you select yes                      here, below settings will be overwritten.</p>', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => 'no',
		'options' => $this->helpers->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	],

	//Restrict Specific Content
	[
		'type' => 'sub-heading',
		'id' => 'cjfmr_restricted_specific_content_heading',
		'label' => __( 'Restrict Specific Content', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'info-full',
		'id' => 'cjfmr_restricted_content_info',
		'label' => '',
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => __( 'Selected content will be available only to logged in users.', 'addon-frontend-auth' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'pages',
		'id' => 'cjfmr_restrict_pages',
		'label' => __( 'Restricted Pages', 'addon-frontend-auth' ),
		'info' => __( 'Select pages you would like to restrict access only for logged in users.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'categories',
		'id' => 'cjfmr_restrict_categories',
		'label' => __( 'Restricted Categories', 'addon-frontend-auth' ),
		'info' => __( 'Select categories you would like to restrict access only for logged in users.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'tags',
		'id' => 'cjfmr_restrict_tags',
		'label' => __( 'Restricted Tags', 'addon-frontend-auth' ),
		'info' => __( 'Select tags you would like to restrict access only for logged in users.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'post-types',
		'id' => 'cjfmr_restrict_post_types',
		'label' => __( 'Restricted Post Types', 'addon-frontend-auth' ),
		'info' => __( 'Select custom post types you would like to restrict access only for logged in users.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'taxonomies',
		'id' => 'cjfmr_restrict_taxonomies',
		'label' => __( 'Restricted Taxonomies', 'addon-frontend-auth' ),
		'info' => __( 'Select tags you would like to restrict access only for logged in users.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'radio-inline',
		'id' => 'cjfmr_restrict_woocommerce',
		'label' => __( 'Restricted WooCommerce', 'addon-frontend-auth' ),
		'info' => __( 'Restrcit WooCommerce Pages.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => 'no',
		'options' => $this->helpers->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'wysiwyg',
		'id' => 'cjfmr_restricted_login_message',
		'label' => __( 'Message to display?', 'addon-frontend-auth' ),
		'info' => __( '<p>You can use following variables in this message.</p><p><code>%%login_link%%</code>: This will be replaced by login link.</p><code>%%register_link%%</code>: This will be replaced by register link.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => __( '<p>You must <b>%%login_link%%</b> or <b>%%register_link%%</b> to view this content.</p>', 'addon-frontend-auth' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'info',
		'id' => 'cjfmr_user_content_shortcode',
		'label' => __( 'User Only Content', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => __( '<p>You can use the following shortcode to display content only to loggedin users.</p>', 'addon-frontend-auth' ) . '<p><code>[cjwpbldr_user_content]....[/cjwpbldr_user_content]</code></p>' . __( '<p>             Only logged in users can see the content within this shortcode, otherwise the above message will be displayed.</p>', 'addon-frontend-auth' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'info',
		'id' => 'cjfmr_visitor_content_shortcode',
		'label' => __( 'Visitors Only Content', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => __( '<p>You can use the following shortcode to display content only to visitors who are not loggedin to the site.</p>', 'addon-frontend-auth' ) . '<p><code>[cjwpbldr_visitor_content]....[/cjwpbldr_visitor_content]</code></p>' . __( '<p>Only logged in users can see the content within this shortcode, otherwise the above message will be displayed.</p>', 'addon-frontend-auth' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
];