<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

$module_helpers = cjwpbldr_frontend_auth_helpers::getInstance();

// page settings
$cjwpbldr_options[] = [
	'type' => 'heading',
	'id' => 'cjfmr_woocommerce_settings_heading',
	'label' => __( 'WooCommerce Setup', 'addon-frontend-auth' ),
	'info' => '',
	'suffix' => '',
	'prefix' => '',
	'default' => '',
	'options' => '', // array in case of dropdown, checkbox and radio buttons
];

$cjwpbldr_options[] = [
	'type' => 'group',
	'id' => 'cjfmr_enable_woocommerce',
	'group' => 'cjfmr_enable_woocommerce',
	'label' => __( 'Enable WooCommerce Integration', 'addon-frontend-auth' ),
	'info' => '',
	'suffix' => '',
	'prefix' => '',
	'default' => 'no',
	'options' => $this->helpers->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	'items' => [
		'yes' => [
			'woocommerce_form_id' => [
				'id' => 'woocommerce_form_id',
				'type' => 'dropdown',
				'label' => __( 'Choose Custom Registration Form', 'addon-frontend-auth' ),
				'info' => __( 'Select custom form to include custom form fields in woocommerce registration form.', 'addon-frontend-auth' ),
				'default' => 1,
				'options' => $module_helpers->getCustomFormsArray(),
			]
		],
		'no' => [],
	]
];

return $cjwpbldr_options;