<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $cjwpbldr_options;
$module_helpers = cjwpbldr_frontend_auth_helpers::getInstance();

return [
	[
		'type' => 'heading',
		'id' => 'cjfmr_config_wp_heading',
		'label' => __( 'Wordpress Defaults', 'addon-frontend-auth' ),
		'info' => __( 'Here you can modify or extend default WordPress behaviour.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'roles',
		'id' => 'cjfmr_disable_dashboard_access',
		'label' => __( 'Restrict Dashboard Access', 'addon-frontend-auth' ),
		'label_suffix' => '',
		'info' => __( 'Select user roles to restrict WordPress Dashboard access.<br>Administrators will always have full access, even if selected.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'params' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'radio-inline',
		'id' => 'cjfmr_disable_default_login_page',
		'label' => __( 'Disable default login page?', 'addon-frontend-auth' ),
		'label_suffix' => '',
		'info' => __( '<p>If <b>Yes</b>, Users will be redirected to frontend pages when they try to login or register via WordPress default links.<br><span class="cj-color-danger">Make sure the page setup is complete and you tried login with custom login form.</span></p>', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'params' => '',
		'default' => 'no',
		'options' => $this->helpers->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'sub-heading',
		'id' => 'cjfmr_config_wp_profile_sync',
		'label' => __( 'Sync Custom Profile Fields', 'addon-frontend-auth' ),
		'info' => __( 'Display all custom Registration fields form the plugin under User(s) dashboard in WordPress.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'radio-inline',
		'id' => 'cjfmr_profile_sync',
		'label' => __( 'Sync Custom Fields', 'addon-frontend-auth' ),
		'label_suffix' => '',
		'info' => __( '<p>If <b>"Yes"</b>, additional profile fields will be displayed under WordPress profile page as well.</p>', 'addon-frontend-auth' ) .
		          sprintf( __( '<a target="_blank" href="%s">Click here</a> to manage register and profile fields.', 'addon-frontend-auth' ), $this->helpers->callbackUrl( 'addon-form-builder', 'cjfb-manage-forms' ) ),
		'suffix' => '',
		'prefix' => '',
		'params' => '',
		'default' => 'yes',
		'options' => $this->helpers->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'dropdown',
		'id' => 'cjfmr_profile_sync_form',
		'label' => __( 'Form to Sync', 'addon-frontend-auth' ),
		'label_suffix' => '',
		'info' => __( 'Choose a Form to Sync Fields', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'params' => '',
		'default' => '',
		'options' => $module_helpers->getCustomFormsArray(), // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_profile_sync_heading',
		'label' => __( 'Additional Profile Fields Heading', 'addon-frontend-auth' ),
		'label_suffix' => '',
		'info' => __( 'This will be displayed above the custom fields in WordPress profile page.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'params' => '',
		'default' => __( 'Additional profile fields', 'addon-frontend-auth' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],

	//User Columns
	[
		'type' => 'sub-heading',
		'id' => 'cjfmr_user_columns_headng',
		'label' => __( 'User Columns', 'addon-frontend-auth' ),
		'info' => __( 'Display User Meta values as user columns on User\'s Dashboard', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'radio-inline',
		'id' => 'cjfmr_show_user_columns',
		'label' => __( 'Show User Columns', 'addon-frontend-auth' ),
		'label_suffix' => '',
		'info' => __( '<p>If <b>"Yes"</b>, additional user columns will be added to the screen which displays all users.</p>', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'params' => '',
		'default' => 'no',
		'options' => $this->helpers->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'multi-dropdown',
		'id' => 'cjfmr_user_columns',
		'label' => __( 'User Meta Keys', 'addon-frontend-auth' ),
		'label_suffix' => '',
		'info' => __( 'Choose user meta keys to display on additional user columns', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'params' => '',
		'default' => '',
		'options' => $module_helpers->getUserMetaKeys(), // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'textarea',
		'id' => 'cjfmr_extra_user_columns',
		'label' => __( 'Additional User Meta Keys', 'addon-frontend-auth' ),
		'label_suffix' => '',
		'info' => __( 'Do not see what you are looking for in the above list? Then please add user meta keys manually here in the box with comma seperated values.<br/>For e:g meta_key1,meta_key2,etc..., without any spaces in between commas', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'params' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],

	//User Avatar
	[
		'type' => 'sub-heading',
		'id' => 'cjfmr_user_avatar_heading',
		'label' => __( 'User Avatar (Profile picture)', 'addon-frontend-auth' ),
		'label_suffix' => '',
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'params' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'radio-inline',
		'id' => 'cjfmr_user_avatar_type',
		'label' => __( 'Avatar Type?', 'addon-frontend-auth' ),
		'label_suffix' => '',
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'params' => '',
		'default' => 'default',
		'options' => [
			'default' => __( 'Default WordPress Avatar', 'addon-frontend-auth' ),
			'custom' => __( 'Custom User Avatar', 'addon-frontend-auth' ),
		],
	],
];