<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

$module_helper = cjwpbldr_frontend_auth_helpers::getInstance();
$send_test_email_url = $this->helpers->currentUrl() . '&cjwpbldr_action=send-test-email';

return [
	[
		'type' => 'heading',
		'id' => 'cjfmr_communication_heading',
		'label' => __( 'Email Configuration', 'addon-frontend-auth' ),
		'info' => __( 'Here you can configure email messages sent via reset password process.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_admin_notification_emnail',
		'label' => __( 'Admin Notifications Email', 'addon-frontend-auth' ),
		'info' => sprintf( __( 'Above email will be used to send all notifications for admin from this plugin/addon. <br/>To use the default WP admin email, leave the option blank.<br/> Default email: <strong>%s</strong>', 'addon-frontend-auth' ), get_option( 'admin_email' ) ),
		'suffix' => '',
		'prefix' => '',
		'default' => get_option( 'admin_email' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_email_from_name',
		'label' => __( 'From Name', 'addon-frontend-auth' ),
		'info' => __( 'All emails will be sent with this as name header.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => get_bloginfo( 'name' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_email_from',
		'label' => __( 'Email address', 'addon-frontend-auth' ),
		'info' => __( 'All emails will be sent from this email address.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => get_option( 'admin_email' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'wysiwyg',
		'id' => 'cjfmr_email_signature',
		'label' => __( 'Signature', 'addon-frontend-auth' ),
		'info' => __( 'This will be used to replace %signature% variable in email messages.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => sprintf( __( 'Regards,<br><a href="%s">%s Team</a>', 'addon-frontend-auth' ), site_url(), get_bloginfo( 'name' ) ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'info',
		'id' => 'cjfmr_send_test_email',
		'label' => __( 'Email Test', 'addon-frontend-auth' ),
		'label_suffix' => sprintf( __( 'Test email will be sent to <span class="cj-color-danger">%s</span>.', 'addon-frontend-auth' ), $module_helper->frontendAuthAdminEmail() ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => sprintf( __( '<p><a href="%s" class="cj-button cj-is-info cj-is-small">Send test email</a></p>Make sure you save the settings before testing.', 'addon-frontend-auth' ), $send_test_email_url ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'sub-heading',
		'id' => 'cjfmr_email_html_heading',
		'label' => __( 'HTML Emails', 'addon-frontend-auth' ),
		'info' => __( 'Here you can add custom HTML code above and below the messages.<br>If you are using any template, make sure the assets are uploaded to a web server and url must be accessible in a browser.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'code-html',
		'id' => 'cjfmr_code_above_email',
		'label' => __( 'Code above email message', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'code-html',
		'id' => 'cjfmr_code_below_email',
		'label' => __( 'Code below email message', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
];