<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

$module_helper = cjwpbldr_frontend_auth_helpers::getInstance();

return [
	// welcome email
	[
		'type' => 'heading',
		'id' => 'cjfmr_email_message_new_user_heading',
		'label' => __( 'Welcome Message', 'addon-frontend-auth' ),
		'info' => __( 'Following email will be sent to user after registration.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_registration_welcome_subject',
		'label' => __( 'Subject', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => $module_helper->getDefaultEmailMessage( 'cjfmr_registration_welcome_subject' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'wysiwyg',
		'id' => 'cjfmr_registration_welcome_message',
		'label' => __( 'Message', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => $module_helper->getDefaultEmailMessage( 'cjfmr_registration_welcome_message' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],

	// verify email address
	[
		'type' => 'heading',
		'id' => 'cjfmr_email_message_registration_heading',
		'label' => __( 'Email Verification', 'addon-frontend-auth' ),
		'info' => __( 'Following email will be sent to verify user\'s email address.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_registration_verify_email_subject',
		'label' => __( 'Subject', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => $module_helper->getDefaultEmailMessage( 'cjfmr_registration_verify_email_subject' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'wysiwyg',
		'id' => 'cjfmr_registration_verify_email_message',
		'label' => __( 'Message', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => $module_helper->getDefaultEmailMessage( 'cjfmr_registration_verify_email_message' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
];