<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

$module_helper = cjwpbldr_frontend_auth_helpers::getInstance();

return [
	[
		'type' => 'heading',
		'id' => 'cjfmr_email_message_password_heading',
		'label' => __( 'Reset Password Verification Email', 'addon-frontend-auth' ),
		'info' => sprintf( __( 'Here you can configure email messages sent via reset password process.<br><a href="%s" target="_blank">Click here</a> to view all variables.', 'addon-frontend-auth' ), $module_helper->callbackUrl( 'addon-frontend-auth', 'configuration-dynamic-variables' ) ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'text',
		'id' => 'cjfmr_reset_password_verification_email_subject',
		'label' => __( 'Subject', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => $module_helper->getDefaultEmailMessage( 'cjfmr_reset_password_verification_email_subject' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'wysiwyg',
		'id' => 'cjfmr_reset_password_verification_email_message',
		'label' => __( 'Message', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => $module_helper->getDefaultEmailMessage( 'cjfmr_reset_password_verification_email_message' ),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
];